/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamemodifiers.contexts.OnBleedingCheck;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.DoubleConfig;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnItemAttributeTooltip;
import com.mlib.items.ItemHelper;
import com.mlib.text.TextHelper;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;

@AutoInstance
public class SharpToolsBleeding
extends GameModifier {
    static final String ATTRIBUTE_ID = "effect.majruszsdifficulty.bleeding.item_tooltip";
    static Supplier<Boolean> IS_ENABLED = () -> false;
    static Supplier<Float> GET_CHANCE = () -> Float.valueOf(0.0f);

    public SharpToolsBleeding() {
        super(Registries.Modifiers.DEFAULT);
        new OnBleedingCheck.Context(OnBleedingCheck.Data::trigger).addCondition(new CustomConditions.GameStage(GameStage.NORMAL)).addCondition((Condition)new BleedingChance(0.25, false)).addCondition((Condition)new ExcludableBleeding()).addCondition((Condition)new Condition.IsLivingBeing()).addCondition(data -> ItemHelper.hasInMainHand((LivingEntity)data.attacker, (Class[])new Class[]{TieredItem.class, TridentItem.class, ShearsItem.class})).addCondition(data -> data.source.m_7640_() == data.attacker).insertTo((GameModifier)this);
        new OnItemAttributeTooltip.Context(this::addTooltip).addCondition(data -> data.item instanceof TieredItem || data.item instanceof TridentItem || data.item instanceof ShearsItem).addCondition(IS_ENABLED).insertTo((GameModifier)this);
        this.name("SharpToolsBleeding").comment("All sharp items (tools, shears etc.) may inflict bleeding.");
    }

    private void addTooltip(OnItemAttributeTooltip.Data data) {
        String chance = TextHelper.percent((float)GET_CHANCE.get().floatValue());
        String amplifier = TextHelper.toRoman((int)(BleedingEffect.getAmplifier() + 1));
        data.add(EquipmentSlot.MAINHAND, (Component)Component.m_237110_((String)ATTRIBUTE_ID, (Object[])new Object[]{chance, amplifier}).m_130940_(ChatFormatting.DARK_GREEN));
    }

    private static class BleedingChance
    extends CustomConditions.CRDChance<OnBleedingCheck.Data> {
        BleedingChance(double chance, boolean scaledByCRD) {
            super(chance, scaledByCRD);
            GET_CHANCE = () -> ((DoubleConfig)this.chance).asFloat();
        }
    }

    private static class ExcludableBleeding
    extends Condition.Excludable<OnBleedingCheck.Data> {
        ExcludableBleeding() {
            IS_ENABLED = () -> this.availability.isEnabled() && BleedingEffect.isEnabled();
        }
    }
}

