/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.mlib.Random;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnDeath;
import com.mlib.math.Range;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@AutoInstance
public class SpawnPlayerZombie
extends GameModifier {
    final DoubleConfig headChance = new DoubleConfig(1.0, Range.CHANCE);
    final DoubleConfig headDropChance = new DoubleConfig(0.1, Range.CHANCE);

    public SpawnPlayerZombie() {
        super(Registries.Modifiers.DEFAULT);
        new OnDeath.Context(this::spawnZombie).addCondition(new CustomConditions.GameStage(GameStage.EXPERT)).addCondition(new CustomConditions.CRDChance(1.0, false)).addCondition((Condition)new Condition.Excludable()).addCondition(data -> data.level != null).addCondition(data -> data.target instanceof Player).addCondition(data -> data.target.m_21023_((MobEffect)Registries.BLEEDING.get()) || data.attacker instanceof Zombie).addConfig((IConfigurable)this.headChance.name("head_chance").comment("Chance for a zombie to have player's head.")).addConfig((IConfigurable)this.headDropChance.name("head_drop_chance").comment("Chance for a zombie to drop player's head.")).insertTo((GameModifier)this);
        new OnDeath.Context(this::giveAdvancement).addCondition(data -> data.target instanceof Zombie).addCondition(data -> data.attacker instanceof ServerPlayer).addCondition(data -> data.target.m_7755_().equals(data.attacker.m_7755_())).insertTo((GameModifier)this);
        this.name("SpawnPlayerZombie").comment("If the player dies from a zombie or bleeding, then a zombie with player's name spawns in the same place.");
    }

    private void spawnZombie(OnDeath.Data data) {
        assert (data.level != null);
        Player player = (Player)data.target;
        EntityType<? extends Zombie> zombieType = SpawnPlayerZombie.getZombieType(data.attacker);
        Zombie zombie = (Zombie)zombieType.m_262455_(data.level, (CompoundTag)null, null, player.m_20183_(), MobSpawnType.EVENT, true, true);
        if (zombie == null) {
            return;
        }
        if (Random.tryChance((double)((Double)this.headChance.get()))) {
            ItemStack playerSkull = SpawnPlayerZombie.getHead(player);
            zombie.m_8061_(EquipmentSlot.HEAD, playerSkull);
            zombie.m_21409_(EquipmentSlot.HEAD, ((Double)this.headDropChance.get()).floatValue());
        }
        zombie.m_6593_(player.m_7755_());
        zombie.m_21553_(false);
        zombie.m_21530_();
    }

    private void giveAdvancement(OnDeath.Data data) {
        Registries.BASIC_TRIGGER.trigger((ServerPlayer)data.attacker, "kill_yourself");
    }

    private static ItemStack getHead(Player player) {
        ItemStack playerSkull = new ItemStack((ItemLike)Items.f_42680_, 1);
        CompoundTag nbt = playerSkull.m_41784_();
        nbt.m_128359_("SkullOwner", player.m_6302_());
        playerSkull.m_41751_(nbt);
        return playerSkull;
    }

    private static EntityType<? extends Zombie> getZombieType(@Nullable LivingEntity attacker) {
        if (attacker instanceof ZombifiedPiglin) {
            return EntityType.f_20531_;
        }
        if (attacker instanceof Husk) {
            return EntityType.f_20458_;
        }
        return EntityType.f_20501_;
    }
}

