/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list.groups;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamemodifiers.configs.MobGroupConfig;
import com.mlib.Random;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnSpawned;
import com.mlib.math.Range;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;

@AutoInstance
public class UndeadArmyPatrol
extends GameModifier {
    final MobGroupConfig mobGroups = new MobGroupConfig(() -> (EntityType)Random.nextRandom(List.of(EntityType.f_20501_, EntityType.f_20458_)), (Range<Integer>)new Range((Number)2, (Number)4), Registries.getLocation("undead_army/equipment_wave_3"), Registries.getLocation("undead_army/equipment_wave_2"));

    public UndeadArmyPatrol() {
        super(Registries.Modifiers.DEFAULT);
        new OnSpawned.ContextSafe(this::spawnGroup).addCondition(new CustomConditions.GameStage(GameStage.NORMAL)).addCondition(new CustomConditions.CRDChance(0.0625, true)).addCondition(new CustomConditions.IsNotPartOfGroup()).addCondition(new CustomConditions.IsNotUndeadArmy()).addCondition(new CustomConditions.IsNotNearUndeadArmy()).addCondition((Condition)new Condition.IsServer()).addCondition((Condition)new Condition.Excludable()).addCondition((Condition)new OnSpawned.IsNotLoadedFromDisk()).addCondition((Condition)new OnSpawned.Is(new Class[]{Zombie.class, Skeleton.class, Husk.class, Stray.class})).addConfigs(new IConfigurable[]{this.mobGroups.name("Undead")}).insertTo((GameModifier)this);
        this.name("UndeadArmyPatrol").comment("Undead may spawn in groups as the Undead Army Patrol.");
    }

    private void spawnGroup(OnSpawned.Data data) {
        this.mobGroups.spawn((PathfinderMob)data.target);
    }
}

