/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gui;

import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.gamemodifiers.contexts.OnClientTick;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BleedingGui {
    static final Particles PARTICLES = new Particles();

    public static void addBloodOnScreen(int count) {
        List<Integer> x = BleedingGui.randomizedCoordinates(6);
        List<Integer> y = BleedingGui.randomizedCoordinates(4);
        IntStream.iterate(0, i -> i + 1).limit(count).forEach(idx -> PARTICLES.get().get((Integer)x.get(idx) * 4 + (Integer)y.get(idx)).makeVisible());
    }

    @SubscribeEvent
    public static void registerGui(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("bleeding", (IGuiOverlay)new Overlay());
    }

    private static List<Integer> randomizedCoordinates(int max) {
        List<Integer> list = IntStream.iterate(0, i -> i + 1).limit(max).boxed().collect(Collectors.toList());
        Collections.shuffle(list);
        return list;
    }

    static class Particle {
        static final int ASSETS_COUNT = 5;
        static final int GRID_WIDTH = 6;
        static final int GRID_HEIGHT = 4;
        static final int LIFETIME = Utility.secondsToTicks((double)9.0);
        static final List<ResourceLocation> ASSETS = new ArrayList<ResourceLocation>();
        final int x;
        final int y;
        int ticks = LIFETIME;
        int phase = 0;

        public Particle(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void makeVisible() {
            if (!this.hasFinished()) {
                return;
            }
            this.ticks = Random.nextInt((int)0, (int)Utility.secondsToTicks((double)2.0));
            this.phase = Random.nextInt((int)0, (int)4);
        }

        public RenderData buildRenderData(int width, int height) {
            float size = (float)height / 6.0f;
            float x = (float)this.x * size + (this.x >= 3 ? (float)width - 6.0f * size : 0.0f);
            float y = (1.5f * (float)this.y + (this.x % 2 == 0 ? 0.0f : 0.5f)) * size;
            return new RenderData((int)x, (int)y, (int)size, ASSETS.get(this.phase));
        }

        public boolean hasFinished() {
            return this.ticks >= LIFETIME;
        }

        public float getAlpha() {
            float ratio = (float)this.ticks / (float)LIFETIME;
            return Mth.m_14036_((float)(0.7f * (1.0f - ratio * ratio)), (float)0.0f, (float)0.7f);
        }

        public void tick() {
            if (Minecraft.m_91087_().m_91104_()) {
                return;
            }
            ++this.ticks;
        }

        static {
            for (int i = 0; i < 5; ++i) {
                ASSETS.add(Registries.getLocation(String.format("textures/particle/blood_%d.png", i + 1)));
            }
        }

        public record RenderData(int x, int y, int size, ResourceLocation resource) {
        }
    }

    static class Overlay
    implements IGuiOverlay {
        Overlay() {
        }

        public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_69478_();
            for (Particle particle : PARTICLES.get()) {
                if (particle.hasFinished()) continue;
                Particle.RenderData renderData = particle.buildRenderData(screenWidth, screenHeight);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)particle.getAlpha());
                RenderSystem.m_157456_((int)0, (ResourceLocation)renderData.resource);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)renderData.x, (int)renderData.y, (float)0.0f, (float)0.0f, (int)renderData.size, (int)renderData.size, (int)renderData.size, (int)renderData.size);
            }
            RenderSystem.m_69461_();
        }
    }

    static class Particles {
        final List<Particle> particles = new ArrayList<Particle>();

        public Particles() {
            for (int x = 0; x < 6; ++x) {
                for (int y = 0; y < 4; ++y) {
                    this.particles.add(new Particle(x, y));
                }
            }
            new OnClientTick.Context(this::updateParticles);
        }

        public List<Particle> get() {
            return this.particles;
        }

        private void updateParticles(OnClientTick.Data data) {
            this.particles.forEach(Particle::tick);
        }
    }
}

