/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EndShardLocatorItem
extends Item {
    private static final String COUNTER_TAG = "EndShardLocatorCounter";
    private static final String POSITION_X_TAG = "EndShardLocatorX";
    private static final String POSITION_Y_TAG = "EndShardLocatorY";
    private static final String POSITION_Z_TAG = "EndShardLocatorZ";
    private static final int COORDINATE_FACTOR = 30;
    private static final float INVALID_DISTANCE = 9001.0f;

    public EndShardLocatorItem() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float calculateDistanceToEndShard(ItemStack itemStack, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
        Player player;
        if (!(entity instanceof Player) || (player = (Player)entity).m_150109_().m_36030_(itemStack) == -1) {
            return 9001.0f;
        }
        Level world = entity.f_19853_;
        Vec3 entityPosition = entity.m_20182_();
        CompoundTag data = itemStack.m_41784_();
        int counter = data.m_128451_(COUNTER_TAG);
        BlockPos nearestEndShard = new BlockPos(data.m_128451_(POSITION_X_TAG), data.m_128451_(POSITION_Y_TAG), data.m_128451_(POSITION_Z_TAG));
        BlockState currentBlockState = world.m_8055_(nearestEndShard);
        boolean isValid = currentBlockState.m_60734_() == Registries.ENDERIUM_SHARD_ORE.get();
        double closestDistance = entityPosition.m_82557_(Vec3.m_82512_((Vec3i)nearestEndShard));
        BlockPos endShardOre = EndShardLocatorItem.findNearestEndShard(world, entityPosition, counter - 30);
        if (endShardOre != null) {
            if (!isValid) {
                nearestEndShard = endShardOre;
            } else {
                double currentDistance = entityPosition.m_82557_(Vec3.m_82512_((Vec3i)endShardOre));
                if (currentDistance < closestDistance) {
                    nearestEndShard = endShardOre;
                }
            }
        }
        data.m_128405_(COUNTER_TAG, (counter + 1) % 60);
        data.m_128405_(POSITION_X_TAG, nearestEndShard.m_123341_());
        data.m_128405_(POSITION_Y_TAG, nearestEndShard.m_123342_());
        data.m_128405_(POSITION_Z_TAG, nearestEndShard.m_123343_());
        return isValid ? (float)closestDistance : 9001.0f;
    }

    @Nullable
    private static BlockPos findNearestEndShard(Level world, Vec3 entityPosition, int yFactor) {
        int y = (int)(entityPosition.f_82480_ + (double)yFactor);
        double closestDistance = 9001.0;
        BlockPos blockPosition = new BlockPos(0, 0, 0);
        int x = (int)(entityPosition.m_7096_() - 30.0);
        while ((double)x < entityPosition.m_7096_() + 30.0) {
            int z = (int)(entityPosition.m_7094_() - 30.0);
            while ((double)z < entityPosition.m_7094_() + 30.0) {
                double distance;
                BlockPos testPosition = new BlockPos(x, y, z);
                if (world.m_8055_(testPosition).m_60734_() == Registries.ENDERIUM_SHARD_ORE.get() && (distance = entityPosition.m_82557_(Vec3.m_82512_((Vec3i)testPosition))) < closestDistance) {
                    closestDistance = distance;
                    blockPosition = testPosition;
                }
                ++z;
            }
            ++x;
        }
        return closestDistance == 9001.0 ? null : blockPosition;
    }
}

