/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.MajruszsHelper;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.GameStageIntegerConfig;
import com.majruszsdifficulty.events.TreasureBagOpenedEvent;
import com.majruszsdifficulty.gamemodifiers.configs.TreasureBagConfig;
import com.majruszsdifficulty.gamemodifiers.contexts.OnTreasureBagOpened;
import com.majruszsdifficulty.treasurebags.TreasureBagProgressClient;
import com.mlib.config.IConfigurable;
import com.mlib.effects.SoundHandler;
import com.mlib.items.ItemHelper;
import com.mlib.math.Range;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TreasureBagItem
extends Item {
    public static final List<TreasureBagItem> TREASURE_BAGS = new ArrayList<TreasureBagItem>();
    static final String ITEM_TOOLTIP_TRANSLATION_KEY = "majruszsdifficulty.treasure_bag.item_tooltip";
    final ResourceLocation lootTableLocation;
    final TreasureBagConfig config;

    public static TreasureBagConfig[] getConfigs() {
        return new TreasureBagConfig[]{UndeadArmy.CONFIG, ElderGuardian.CONFIG, Wither.CONFIG, EnderDragon.CONFIG, Fishing.CONFIG, Pillager.CONFIG, Warden.CONFIG};
    }

    public static LootContext generateLootContext(Player player) {
        LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerLevel)player.f_19853_);
        lootContextBuilder.m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_());
        lootContextBuilder.m_78972_(LootContextParams.f_81455_, (Object)player);
        return lootContextBuilder.m_78975_(LootContextParamSets.f_81416_);
    }

    public TreasureBagItem(ResourceLocation location, TreasureBagConfig config) {
        super(new Item.Properties().m_41487_(16).m_41497_(Rarity.UNCOMMON));
        this.lootTableLocation = location;
        this.config = config;
        TREASURE_BAGS.add(this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.f_46443_) {
            ItemHelper.consumeItemOnUse((ItemStack)itemStack, (Player)player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.triggerTreasureBagAdvancement(serverPlayer);
            }
            SoundHandler.ITEM_PICKUP.play(level, player.m_20182_());
            List<ItemStack> loot = this.generateLoot(player);
            MinecraftForge.EVENT_BUS.post((Event)new TreasureBagOpenedEvent(player, this, loot));
            OnTreasureBagOpened.accept(new OnTreasureBagOpened.Data(player, this, loot));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                loot.forEach(reward -> ItemHelper.giveItemStackToPlayer((ItemStack)reward, (Player)player, (ServerLevel)serverLevel));
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        MajruszsHelper.addAdvancedTranslatableTexts(tooltip, flag, ITEM_TOOLTIP_TRANSLATION_KEY, " ");
        tooltip.addAll(TreasureBagProgressClient.getTextComponents(this));
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public LootTable getLootTable() {
        return ServerLifecycleHooks.getCurrentServer().m_129898_().m_79217_(this.lootTableLocation);
    }

    private List<ItemStack> generateLoot(Player player) {
        LootTable lootTable = this.getLootTable();
        return lootTable.m_230922_(TreasureBagItem.generateLootContext(player));
    }

    private void triggerTreasureBagAdvancement(ServerPlayer player) {
        Registries.TREASURE_BAG_TRIGGER.trigger(player, this, player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)this)));
    }

    public static class UndeadArmy
    extends TreasureBagItem {
        public static final ResourceLocation LOCATION = Registries.getLocation("gameplay/undead_army_treasure_loot");
        public static final TreasureBagConfig CONFIG = new TreasureBagConfig("UndeadArmy");

        public UndeadArmy() {
            super(LOCATION, CONFIG);
        }
    }

    public static class ElderGuardian
    extends TreasureBagItem {
        public static final ResourceLocation LOCATION = Registries.getLocation("gameplay/elder_guardian_treasure_loot");
        public static final TreasureBagConfig CONFIG = new TreasureBagConfig("ElderGuardian");

        public ElderGuardian() {
            super(LOCATION, CONFIG);
        }
    }

    public static class Wither
    extends TreasureBagItem {
        public static final ResourceLocation LOCATION = Registries.getLocation("gameplay/wither_treasure_loot");
        public static final TreasureBagConfig CONFIG = new TreasureBagConfig("Wither");

        public Wither() {
            super(LOCATION, CONFIG);
        }
    }

    public static class EnderDragon
    extends TreasureBagItem {
        public static final ResourceLocation LOCATION = Registries.getLocation("gameplay/ender_dragon_treasure_loot");
        public static final TreasureBagConfig CONFIG = new TreasureBagConfig("EnderDragon");

        public EnderDragon() {
            super(LOCATION, CONFIG);
        }
    }

    public static class Fishing
    extends TreasureBagItem {
        public static final ResourceLocation LOCATION = Registries.getLocation("gameplay/fishing_treasure_loot");
        public static final TreasureBagConfig CONFIG = new TreasureBagConfig("Fishing");
        public static final GameStageIntegerConfig REQUIRED_FISH_COUNT = new GameStageIntegerConfig(20, 15, 10, (Range<Integer>)new Range((Number)3, (Number)100));

        public Fishing() {
            super(LOCATION, CONFIG);
        }

        static {
            CONFIG.addConfig((IConfigurable)REQUIRED_FISH_COUNT.name("RequiredFishCount").comment("Required amount of items fished to get this Treasure Bag."));
        }
    }

    public static class Pillager
    extends TreasureBagItem {
        public static final ResourceLocation LOCATION = Registries.getLocation("gameplay/pillager_treasure_loot");
        public static final TreasureBagConfig CONFIG = new TreasureBagConfig("PillagerRaid");

        public Pillager() {
            super(LOCATION, CONFIG);
        }
    }

    public static class Warden
    extends TreasureBagItem {
        public static final ResourceLocation LOCATION = Registries.getLocation("gameplay/warden_treasure_loot");
        public static final TreasureBagConfig CONFIG = new TreasureBagConfig("Warden");

        public Warden() {
            super(LOCATION, CONFIG);
        }
    }
}

