/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.majruszsdifficulty.Registries;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class CurseRandomlyFunction
extends LootItemConditionalFunction {
    final List<ResourceLocation> excludedEnchantments;

    public static LootItemFunctionType newType() {
        return new LootItemFunctionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    }

    public CurseRandomlyFunction(LootItemCondition[] itemConditions, List<ResourceLocation> excludedEnchantments) {
        super(itemConditions);
        this.excludedEnchantments = excludedEnchantments;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)Registries.CURSE_RANDOMLY.get();
    }

    public ItemStack m_7372_(ItemStack itemStack, LootContext context) {
        List<Enchantment> curses;
        RandomSource randomSource = context.m_230907_();
        ArrayList<Enchantment> randomEnchantments = new ArrayList<Enchantment>();
        List<Enchantment> enchantments = this.buildValidEnchantmentList(itemStack);
        if (!enchantments.isEmpty()) {
            randomEnchantments.add(enchantments.get(randomSource.m_188503_(enchantments.size())));
        }
        if (!(curses = this.buildValidCurseList(itemStack)).isEmpty()) {
            randomEnchantments.add(curses.get(randomSource.m_188503_(curses.size())));
        }
        return !randomEnchantments.isEmpty() ? CurseRandomlyFunction.enchantItem(itemStack, randomSource, randomEnchantments) : itemStack;
    }

    private List<Enchantment> buildValidEnchantmentList(ItemStack itemStack) {
        return ForgeRegistries.ENCHANTMENTS.getEntries().stream().filter(enchantment -> !this.excludedEnchantments.contains(((ResourceKey)enchantment.getKey()).m_135782_())).map(Map.Entry::getValue).filter(Enchantment::m_6592_).filter(enchantment -> !enchantment.m_6589_()).filter(enchantment -> enchantment.m_6081_(itemStack)).toList();
    }

    private List<Enchantment> buildValidCurseList(ItemStack itemStack) {
        return ForgeRegistries.ENCHANTMENTS.getEntries().stream().filter(enchantment -> !this.excludedEnchantments.contains(((ResourceKey)enchantment.getKey()).m_135782_())).map(Map.Entry::getValue).filter(Enchantment::m_6592_).filter(Enchantment::m_6589_).filter(enchantment -> enchantment.m_6081_(itemStack)).toList();
    }

    private static ItemStack enchantItem(ItemStack itemStack, RandomSource randomSource, List<Enchantment> enchantments) {
        if (itemStack.m_150930_(Items.f_42517_)) {
            itemStack = new ItemStack((ItemLike)Items.f_42690_);
        }
        for (Enchantment enchantment : enchantments) {
            int level = Mth.m_216271_((RandomSource)randomSource, (int)enchantment.m_44702_(), (int)enchantment.m_6586_());
            if (itemStack.m_150930_(Items.f_42690_)) {
                EnchantedBookItem.m_41153_((ItemStack)itemStack, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
                continue;
            }
            itemStack.m_41663_(enchantment, level);
        }
        return itemStack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CurseRandomlyFunction> {
        public CurseRandomlyFunction deserialize(JsonObject jsonObject, JsonDeserializationContext context, LootItemCondition[] itemConditions) {
            ArrayList<ResourceLocation> excludedEnchantments = new ArrayList<ResourceLocation>();
            if (jsonObject.has("excluding")) {
                jsonObject.get("excluding").getAsJsonArray().forEach(enchantment -> excludedEnchantments.add(new ResourceLocation(enchantment.getAsString())));
            }
            return new CurseRandomlyFunction(itemConditions, excludedEnchantments);
        }
    }
}

