/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.models;

import com.majruszsdifficulty.entities.CerberusEntity;
import com.mlib.animations.Animation;
import com.mlib.animations.Frame;
import com.mlib.animations.InterpolationType;
import com.mlib.math.VectorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class CerberusModel<Type extends CerberusEntity>
extends HierarchicalModel<Type> {
    static final Animation<Float> BITE_JAW_ROTATION_X = new Animation(1.0);
    static final Animation<Float> BREATH_JAW_ROTATION_X = new Animation(1.0);
    static final Animation<Vector3f> BITE_SIDE_NECK_ROTATION = new Animation(1.0);
    static final Animation<Float> GALLOP_FRONT_LEG_1_ROTATION_X = new Animation(1.0);
    static final Animation<Float> GALLOP_FRONT_LEG_2_ROTATION_X = new Animation(1.0);
    static final Animation<Float> GALLOP_HIND_LEG_1_ROTATION_X = new Animation(1.0);
    static final Animation<Float> GALLOP_HIND_LEG_2_ROTATION_X = new Animation(1.0);
    static final Animation<Float> GALLOP_SPINE_ROTATION_X = new Animation(1.0);
    static final Animation<Float> GALLOP_BODY_POSITION_Y = new Animation(1.0);
    final ModelPart root;
    final ModelPart body;
    final ModelPart spine;
    final ModelPart necks;
    final ModelPart neck1;
    final ModelPart head1;
    final ModelPart jawUpper1;
    final ModelPart jawLower1;
    final ModelPart neck2;
    final ModelPart head2;
    final ModelPart jawUpper2;
    final ModelPart jawLower2;
    final ModelPart neck3;
    final ModelPart head3;
    final ModelPart jawUpper3;
    final ModelPart jawLower3;
    final ModelPart frontThigh1;
    final ModelPart frontThigh2;
    final ModelPart hindThigh1;
    final ModelPart hindThigh2;

    public CerberusModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.spine = this.body.m_171324_("spine");
        this.necks = this.spine.m_171324_("necks");
        this.neck1 = this.necks.m_171324_("neck1");
        this.head1 = this.neck1.m_171324_("head1");
        this.jawUpper1 = this.head1.m_171324_("jawUpper1");
        this.jawLower1 = this.head1.m_171324_("jawLower1");
        this.neck2 = this.necks.m_171324_("neck2");
        this.head2 = this.neck2.m_171324_("head2");
        this.jawUpper2 = this.head2.m_171324_("jawUpper2");
        this.jawLower2 = this.head2.m_171324_("jawLower2");
        this.neck3 = this.necks.m_171324_("neck3");
        this.head3 = this.neck3.m_171324_("head3");
        this.jawUpper3 = this.head3.m_171324_("jawUpper3");
        this.jawLower3 = this.head3.m_171324_("jawLower3");
        this.frontThigh1 = this.spine.m_171324_("frontThigh1");
        this.frontThigh2 = this.spine.m_171324_("frontThigh2");
        this.hindThigh1 = this.spine.m_171324_("hindThigh1");
        this.hindThigh2 = this.spine.m_171324_("hindThigh2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)25.0f, (float)0.0f));
        PartDefinition spine = body.m_171599_("spine", CubeListBuilder.m_171558_().m_171514_(28, 23).m_171488_(-2.0f, -2.0f, -12.0f, 4.0f, 4.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-25.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition necks = spine.m_171599_("necks", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-10.0f));
        PartDefinition neck1 = necks.m_171599_("neck1", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-2.0f, -2.0f, -6.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)-4.0f, (float)2.0f, (float)-1.0f, (float)0.0f, (float)0.6109f, (float)0.0f));
        PartDefinition head1 = neck1.m_171599_("head1", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)-6.0f, (float)0.1745f, (float)-0.1745f, (float)0.0f));
        PartDefinition leftEar1 = head1.m_171599_("leftEar1", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-0.5f, -2.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)3.5f, (float)-4.5f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar1 = head1.m_171599_("rightEar1", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-0.5f, -2.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)-3.5f, (float)-4.5f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition jawUpper1 = head1.m_171599_("jawUpper1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -1.5f, -6.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-6.0f));
        PartDefinition teethUpper1 = jawUpper1.m_171599_("teethUpper1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-2.5f, -1.5f, -6.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition jawLower1 = head1.m_171599_("jawLower1", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-2.5f, -0.4f, -5.9f, 5.0f, 1.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)0.0f, (float)3.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition teethLower1 = jawLower1.m_171599_("teethLower1", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-2.5f, -2.4f, -5.9f, 5.0f, 2.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition neck2 = necks.m_171599_("neck2", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-2.0f, -2.0f, -6.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head2 = neck2.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)-7.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar2 = head2.m_171599_("leftEar2", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-0.5f, -2.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)3.5f, (float)-4.5f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar2 = head2.m_171599_("rightEar2", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-0.5f, -2.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)-3.5f, (float)-4.5f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition jawUpper2 = head2.m_171599_("jawUpper2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -1.5f, -6.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-6.0f));
        PartDefinition teethUpper2 = jawUpper2.m_171599_("teethUpper2", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-2.5f, -1.5f, -6.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition jawLower2 = head2.m_171599_("jawLower2", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-2.5f, -0.4f, -5.9f, 5.0f, 1.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)0.0f, (float)3.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition teethLower2 = jawLower2.m_171599_("teethLower2", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-2.5f, -2.4f, -5.9f, 5.0f, 2.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition neck3 = necks.m_171599_("neck3", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-2.0f, -2.0f, -6.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)4.0f, (float)2.0f, (float)-1.0f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        PartDefinition head3 = neck3.m_171599_("head3", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)-6.0f, (float)0.1745f, (float)0.1745f, (float)0.0f));
        PartDefinition leftEar3 = head3.m_171599_("leftEar3", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-0.5f, -2.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)3.5f, (float)-4.5f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar3 = head3.m_171599_("rightEar3", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-0.5f, -2.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)-3.5f, (float)-4.5f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition jawUpper3 = head3.m_171599_("jawUpper3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -1.5f, -6.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-6.0f));
        PartDefinition teethUpper3 = jawUpper3.m_171599_("teethUpper3", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-2.5f, -1.5f, -6.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition jawLower3 = head3.m_171599_("jawLower3", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-2.5f, -0.4f, -5.9f, 5.0f, 1.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)0.0f, (float)3.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition teethLower3 = jawLower3.m_171599_("teethLower3", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-2.5f, -2.4f, -5.9f, 5.0f, 2.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition chest = spine.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-6.0f, -4.5f, -5.0f, 12.0f, 9.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)-3.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition frontThigh1 = spine.m_171599_("frontThigh1", CubeListBuilder.m_171558_().m_171514_(80, 19).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)1.0f, (float)-9.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition frontCalf1 = frontThigh1.m_171599_("frontCalf1", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)10.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition frontThigh2 = spine.m_171599_("frontThigh2", CubeListBuilder.m_171558_().m_171514_(80, 19).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)1.0f, (float)-9.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition frontCalf2 = frontThigh2.m_171599_("frontCalf2", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)10.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tail = spine.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(28, 23).m_171488_(-1.0f, 0.0f, -1.5f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)13.5f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(28, 23).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)-0.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition hindThigh1 = spine.m_171599_("hindThigh1", CubeListBuilder.m_171558_().m_171514_(80, 19).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)1.0f, (float)10.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition hindCalf1 = hindThigh1.m_171599_("hindCalf1", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)10.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition hindThigh2 = spine.m_171599_("hindThigh2", CubeListBuilder.m_171558_().m_171514_(80, 19).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)1.0f, (float)10.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition hindCalf2 = hindThigh2.m_171599_("hindCalf2", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)10.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)96, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(Type cerberus, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float breathJawRotation;
        float biteJawRotation;
        float jawRotation;
        CerberusEntity.Skills skills = ((CerberusEntity)((Object)cerberus)).getCustomSkills();
        this.spine.f_104203_ = (float)Math.toRadians(0.0);
        this.necks.f_104204_ = (float)Math.toRadians(netHeadYaw);
        this.necks.f_104203_ = (float)Math.toRadians(headPitch) + 0.0873f;
        this.jawUpper2.f_104203_ = this.jawUpper3.f_104203_ = (jawRotation = (float)Math.toRadians(-1.0 * Math.sin(ageInTicks / 10.0f) - (double)(15.0f * Mth.m_14036_((float)(1.2f - this.getPlayerDistance(cerberus) / 5.0f), (float)0.0f, (float)1.0f))));
        this.jawUpper1.f_104203_ = this.jawUpper3.f_104203_;
        this.jawLower2.f_104203_ = this.jawLower3.f_104203_ = jawRotation;
        this.jawLower1.f_104203_ = this.jawLower3.f_104203_;
        if (((CerberusEntity)((Object)cerberus)).hasTarget) {
            swingRatio = limbSwing * 0.15f % 1.0f;
            this.frontThigh1.f_104203_ = (float)Math.toRadians(30.0) - ((Float)GALLOP_FRONT_LEG_1_ROTATION_X.apply(swingRatio, ageInTicks)).floatValue() * limbSwingAmount;
            this.frontThigh2.f_104203_ = (float)Math.toRadians(30.0) - ((Float)GALLOP_FRONT_LEG_2_ROTATION_X.apply(swingRatio, ageInTicks)).floatValue() * limbSwingAmount;
            this.hindThigh1.f_104203_ = (float)Math.toRadians(-20.0) - ((Float)GALLOP_HIND_LEG_1_ROTATION_X.apply(swingRatio, ageInTicks)).floatValue() * limbSwingAmount;
            this.hindThigh2.f_104203_ = (float)Math.toRadians(-20.0) - ((Float)GALLOP_HIND_LEG_2_ROTATION_X.apply(swingRatio, ageInTicks)).floatValue() * limbSwingAmount;
            this.spine.f_104203_ -= ((Float)GALLOP_SPINE_ROTATION_X.apply(swingRatio, ageInTicks)).floatValue() * limbSwingAmount;
            this.body.f_104201_ = 25.0f - ((Float)GALLOP_BODY_POSITION_Y.apply(swingRatio, ageInTicks)).floatValue() * limbSwingAmount;
        } else {
            swingRatio = (float)(Math.cos(0.4f * limbSwing) * (double)limbSwingAmount);
            this.frontThigh2.f_104203_ = (float)Math.toRadians(30.0f + 30.0f * swingRatio);
            this.hindThigh2.f_104203_ = (float)Math.toRadians(-20.0f + 30.0f * swingRatio);
            this.frontThigh1.f_104203_ = (float)Math.toRadians(30.0f - 30.0f * swingRatio);
            this.hindThigh1.f_104203_ = (float)Math.toRadians(-20.0f - 30.0f * swingRatio);
            this.body.f_104201_ = 25.0f + 1.0f * Math.abs(swingRatio);
        }
        float biteRatio = skills.getRatio(CerberusEntity.SkillType.BITE);
        this.jawUpper2.f_104203_ = this.jawUpper3.f_104203_ = (biteJawRotation = (float)Mth.m_14008_((double)(jawRotation - ((Float)BITE_JAW_ROTATION_X.apply(biteRatio, ageInTicks)).floatValue()), (double)Math.toRadians(-30.0), (double)0.0));
        this.jawUpper1.f_104203_ = this.jawUpper3.f_104203_;
        this.jawLower2.f_104203_ = this.jawLower3.f_104203_ = biteJawRotation;
        this.jawLower1.f_104203_ = this.jawLower3.f_104203_;
        float breathRatio = skills.getRatio(CerberusEntity.SkillType.FIRE_BREATH);
        this.jawUpper2.f_104203_ = this.jawUpper3.f_104203_ = (breathJawRotation = (float)Mth.m_14008_((double)(biteJawRotation - ((Float)BREATH_JAW_ROTATION_X.apply(breathRatio, ageInTicks)).floatValue()), (double)Math.toRadians(-30.0), (double)0.0));
        this.jawUpper1.f_104203_ = this.jawUpper3.f_104203_;
        this.jawLower2.f_104203_ = this.jawLower3.f_104203_ = breathJawRotation;
        this.jawLower1.f_104203_ = this.jawLower3.f_104203_;
        Vector3f neckRotation = new Vector3f((Vector3fc)BITE_SIDE_NECK_ROTATION.apply(biteRatio, ageInTicks)).mul((float)Math.PI / 180);
        this.neck1.f_104203_ = neckRotation.x;
        this.neck1.f_104205_ = neckRotation.z;
        this.neck3.f_104203_ = neckRotation.x;
        this.neck3.f_104205_ = -neckRotation.z;
    }

    private float getPlayerDistance(Type cerberus) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && !player.m_5833_() ? (float)VectorHelper.distance((Vec3)player.m_20182_(), (Vec3)cerberus.m_20182_()) : Float.MAX_VALUE;
    }

    static {
        BITE_JAW_ROTATION_X.add(0.0f, (Frame)new Frame.Degrees(0.0f)).add(0.3f, (Frame)new Frame.Degrees(30.0f, InterpolationType.SQUARE)).add(0.7f, (Frame)new Frame.Degrees(-30.0f, InterpolationType.SQUARE)).add(1.0f, (Frame)new Frame.Degrees(0.0f, InterpolationType.SQUARE));
        BREATH_JAW_ROTATION_X.add(0.0f, (Frame)new Frame.Degrees(0.0f)).add(0.15f, (Frame)new Frame.Degrees(0.0f)).add(0.25f, (Frame)new Frame.Degrees(30.0f, InterpolationType.SQUARE)).add(0.4f, (Frame)new Frame.Degrees(0.0f, InterpolationType.SQUARE)).add(0.5f, (Frame)new Frame.Degrees(30.0f, InterpolationType.SQUARE)).add(0.65f, (Frame)new Frame.Degrees(0.0f, InterpolationType.SQUARE)).add(0.75f, (Frame)new Frame.Degrees(30.0f, InterpolationType.SQUARE)).add(0.9f, (Frame)new Frame.Degrees(0.0f, InterpolationType.SQUARE)).add(1.0f, (Frame)new Frame.Degrees(0.0f));
        BITE_SIDE_NECK_ROTATION.add(0.0f, (Frame)new Frame.Vector(0.0f, 0.0f, 0.0f)).add(0.3f, (Frame)new Frame.Vector(-15.0f, 0.0f, -30.0f, InterpolationType.SQUARE)).add(0.7f, (Frame)new Frame.Vector(0.0f, 0.0f, 0.0f, InterpolationType.SQUARE)).add(1.0f, (Frame)new Frame.Vector(0.0f, 0.0f, 0.0f));
        GALLOP_FRONT_LEG_1_ROTATION_X.add(0.0f, (Frame)new Frame.Degrees(45.0f)).add(0.25f, (Frame)new Frame.Degrees(15.0f)).add(0.5f, (Frame)new Frame.Degrees(-15.0f)).add(0.75f, (Frame)new Frame.Degrees(30.0f)).add(1.0f, (Frame)new Frame.Degrees(45.0f));
        GALLOP_FRONT_LEG_2_ROTATION_X.add(0.0f, (Frame)new Frame.Degrees(15.0f)).add(0.25f, (Frame)new Frame.Degrees(0.0f)).add(0.5f, (Frame)new Frame.Degrees(30.0f)).add(0.75f, (Frame)new Frame.Degrees(45.0f)).add(1.0f, (Frame)new Frame.Degrees(15.0f));
        GALLOP_HIND_LEG_1_ROTATION_X.add(0.0f, (Frame)new Frame.Degrees(-15.0f)).add(0.25f, (Frame)new Frame.Degrees(15.0f)).add(0.5f, (Frame)new Frame.Degrees(-15.0f)).add(0.75f, (Frame)new Frame.Degrees(-45.0f)).add(1.0f, (Frame)new Frame.Degrees(-15.0f));
        GALLOP_HIND_LEG_2_ROTATION_X.add(0.0f, (Frame)new Frame.Degrees(-45.0f)).add(0.25f, (Frame)new Frame.Degrees(-15.0f)).add(0.5f, (Frame)new Frame.Degrees(15.0f)).add(0.75f, (Frame)new Frame.Degrees(-15.0f)).add(1.0f, (Frame)new Frame.Degrees(-45.0f));
        GALLOP_SPINE_ROTATION_X.add(0.0f, (Frame)new Frame.Degrees(0.0f)).add(0.25f, (Frame)new Frame.Degrees(-5.0f, InterpolationType.SQUARE)).add(0.5f, (Frame)new Frame.Degrees(5.0f, InterpolationType.SQUARE)).add(0.75f, (Frame)new Frame.Degrees(10.0f, InterpolationType.SQUARE)).add(1.0f, (Frame)new Frame.Degrees(0.0f, InterpolationType.SQUARE));
        GALLOP_BODY_POSITION_Y.add(0.0f, (Frame)new Frame.Value(0.0f)).add(0.25f, (Frame)new Frame.Value(0.0f, InterpolationType.SQUARE)).add(0.5f, (Frame)new Frame.Value(0.0f, InterpolationType.SQUARE)).add(0.75f, (Frame)new Frame.Value(2.0f, InterpolationType.SQUARE)).add(1.0f, (Frame)new Frame.Value(0.0f, InterpolationType.SQUARE));
    }
}

