/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.models;

import com.majruszsdifficulty.entities.TankEntity;
import com.mlib.animations.Animation;
import com.mlib.animations.Frame;
import com.mlib.animations.InterpolationType;
import com.mlib.math.VectorHelper;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TankModel<Type extends TankEntity>
extends HierarchicalModel<Type> {
    static final Animation<Float> SPECIAL_ATTACK_BODY_X = new Animation(1.0);
    static final Animation<Float> SPECIAL_ATTACK_ARMS_X = new Animation(1.0);
    static final Animation<Float> NORMAL_ATTACK_BODY_Y = new Animation(1.0);
    static final Animation<Vector3f> NORMAL_ATTACK_ARM = new Animation(1.0);
    public ModelPart root;
    public ModelPart body;
    public ModelPart head;
    public ModelPart arms;
    public ModelPart leftArm;
    public ModelPart leftForearm;
    public ModelPart rightArm;
    public ModelPart rightForearm;
    public ModelPart leftLeg;
    public ModelPart rightLeg;

    public TankModel(ModelPart modelPart) {
        this.root = modelPart;
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arms = this.body.m_171324_("arms");
        this.leftArm = this.arms.m_171324_("leftArm");
        this.leftForearm = this.leftArm.m_171324_("leftForearm");
        this.rightArm = this.arms.m_171324_("rightArm");
        this.rightForearm = this.rightArm.m_171324_("rightForearm");
        this.leftLeg = this.root.m_171324_("leftLeg");
        this.rightLeg = this.root.m_171324_("rightLeg");
    }

    public void setupAnim(Type tank, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        TankEntity.Skills skills = ((TankEntity)((Object)tank)).getCustomSkills();
        float limbFactor1 = limbSwing * 0.3333f;
        float limbFactor2 = 0.9f * limbSwingAmount;
        float bodyFactor = 0.2f * limbSwingAmount;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) + 0.0873f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)limbFactor1) * limbFactor2;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbFactor1 + (float)Math.PI)) * limbFactor2;
        this.body.f_104205_ = Mth.m_14089_((float)limbFactor1) * bodyFactor;
        boolean isLeftHandAttack = skills.isUsing(TankEntity.SkillType.STANDARD_LEFT_ATTACK);
        float handMultiplier = isLeftHandAttack ? -1.0f : 1.0f;
        float standardAttackRatio = skills.getRatio(isLeftHandAttack ? TankEntity.SkillType.STANDARD_LEFT_ATTACK : TankEntity.SkillType.STANDARD_RIGHT_ATTACK);
        this.body.f_104204_ = this.head.f_104204_ * 0.4f + handMultiplier * ((Float)NORMAL_ATTACK_BODY_Y.apply(standardAttackRatio, ageInTicks)).floatValue();
        float extraLeftArmRotationX = (float)(Math.cos(limbFactor1) * (double)limbSwingAmount) * 20.0f;
        this.rotateArm(this.leftArm, ageInTicks, skills.getRatio(TankEntity.SkillType.STANDARD_LEFT_ATTACK), extraLeftArmRotationX);
        float extraRightArmRotationX = (float)(Math.cos(limbFactor1 + (float)Math.PI) * (double)limbSwingAmount) * 20.0f;
        this.rotateArm(this.rightArm, ageInTicks, skills.getRatio(TankEntity.SkillType.STANDARD_RIGHT_ATTACK), extraRightArmRotationX);
        float heavyAttackRatio = skills.getRatio(TankEntity.SkillType.HEAVY_ATTACK);
        this.body.f_104203_ = ((Float)SPECIAL_ATTACK_BODY_X.apply(heavyAttackRatio, ageInTicks)).floatValue();
        this.arms.f_104203_ = ((Float)SPECIAL_ATTACK_ARMS_X.apply(heavyAttackRatio, ageInTicks)).floatValue();
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-8.0f, -22.0f, -5.0f, 16.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(36, 40).m_171488_(-1.0f, -23.0f, 1.0f, 2.0f, 22.0f, 2.0f, new CubeDeformation(-0.1f)).m_171514_(0, 40).m_171488_(-6.0f, -4.0f, -3.0f, 12.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-22.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-22.0f, (float)0.0f));
        PartDefinition rightArm = arms.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 16.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)-8.5f, (float)0.0f, (float)-0.5f, (float)0.0436f, (float)0.0873f, (float)0.2182f));
        PartDefinition rightForearm = rightArm.m_171599_("rightForearm", CubeListBuilder.m_171558_().m_171514_(44, 37).m_171488_(-2.5f, -0.5f, -2.5f, 5.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)15.5f, (float)0.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = arms.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 16.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)8.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)-0.0873f, (float)-0.2182f));
        PartDefinition leftForearm = leftArm.m_171599_("leftForearm", CubeListBuilder.m_171558_().m_171514_(44, 37).m_171488_(-2.5f, -2.0f, -3.5f, 5.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-1.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partDefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)12.0f, (float)0.0f));
        PartDefinition rightLeg = partDefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    private void rotateArm(ModelPart arm, float ageInTicks, float duration, float extraRotationX) {
        float multiplier = arm == this.leftArm ? -1.0f : 1.0f;
        Vector3f vectorHandMultiplier = new Vector3f(1.0f, multiplier, multiplier);
        Vector3f rotation = VectorHelper.add((Vector3f)((Vector3f)NORMAL_ATTACK_ARM.apply(duration, ageInTicks)), (Vector3f)new Vector3f(extraRotationX, 0.0f, 0.0f));
        Animation.applyRotationInDegrees((Vector3f)VectorHelper.multiply((Vector3f)rotation, (Vector3f)vectorHandMultiplier), (ModelPart[])new ModelPart[]{arm});
    }

    static {
        SPECIAL_ATTACK_BODY_X.add(0.0f, (Frame)new Frame.Degrees(10.0f)).add(0.3f, (Frame)new Frame.Degrees(-30.0f, InterpolationType.SQUARE)).add(0.4f, (Frame)new Frame.Degrees(-30.0f)).add(0.6f, (Frame)new Frame.Degrees(45.0f, InterpolationType.SQUARE)).add(0.7f, (Frame)new Frame.Degrees(35.0f)).add(0.85f, (Frame)new Frame.Degrees(0.0f, InterpolationType.SQUARE)).add(1.0f, (Frame)new Frame.Degrees(10.0f));
        SPECIAL_ATTACK_ARMS_X.add(0.0f, (Frame)new Frame.Degrees(0.0f)).add(0.4f, (Frame)new Frame.Degrees(-160.0f, InterpolationType.SQUARE)).add(0.6f, (Frame)new Frame.Degrees(-40.0f, InterpolationType.SQUARE)).add(0.7f, (Frame)new Frame.Degrees(-30.0f)).add(0.85f, (Frame)new Frame.Degrees(10.0f, InterpolationType.SQUARE)).add(1.0f, (Frame)new Frame.Degrees(0.0f, InterpolationType.SQUARE));
        NORMAL_ATTACK_BODY_Y.add(0.0f, (Frame)new Frame.Degrees(0.0f)).add(0.15f, (Frame)new Frame.Degrees(30.0f, InterpolationType.SQUARE)).add(0.25f, (Frame)new Frame.Degrees(30.0f)).add(0.45f, (Frame)new Frame.Degrees(-60.0f, InterpolationType.SQUARE)).add(0.55f, (Frame)new Frame.Degrees(-50.0f)).add(1.0f, (Frame)new Frame.Degrees(0.0f, InterpolationType.SQUARE));
        NORMAL_ATTACK_ARM.add(0.0f, (Frame)new Frame.Vector(0.0f, 5.0f, 12.5f)).add(0.2f, (Frame)new Frame.Vector(45.0f, 0.0f, 45.0f, InterpolationType.SQUARE)).add(0.3f, (Frame)new Frame.Vector(45.0f, 0.0f, 45.0f)).add(0.5f, (Frame)new Frame.Vector(-90.0f, -30.0f, 60.0f, InterpolationType.SQUARE)).add(0.6f, (Frame)new Frame.Vector(-80.0f, -25.0f, 50.0f, InterpolationType.SQUARE)).add(1.0f, (Frame)new Frame.Vector(0.0f, 5.0f, 12.5f, InterpolationType.SQUARE));
    }
}

