/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebags;

import com.majruszsdifficulty.PacketHandler;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.contexts.OnTreasureBagOpened;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.majruszsdifficulty.treasurebags.data.LootData;
import com.majruszsdifficulty.treasurebags.data.LootProgressData;
import com.majruszsdifficulty.treasurebags.data.TreasureBagData;
import com.mlib.ObfuscationGetter;
import com.mlib.Utility;
import com.mlib.annotations.AutoInstance;
import com.mlib.data.SerializableStructure;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.contexts.OnPlayerLogged;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.network.PacketDistributor;

public class TreasureBagProgressManager
extends SerializableStructure {
    static final ObfuscationGetter.Field<LootTable, List<LootPool>> POOLS = new ObfuscationGetter.Field(LootTable.class, "f_79109_");
    static final ObfuscationGetter.Field<LootPool, LootPoolEntryContainer[]> ENTRIES = new ObfuscationGetter.Field(LootPool.class, "f_79023_");
    final Map<String, LootProgressData> lootProgressMap = new HashMap<String, LootProgressData>();

    public TreasureBagProgressManager() {
        this.define("LootProgress", () -> this.lootProgressMap, this.lootProgressMap::putAll, LootProgressData::new);
    }

    public void clearProgress(Player player) {
        this.lootProgressMap.remove(player.m_20148_().toString());
        this.createDefaultProgress(player);
        this.sendMessageTo(player);
    }

    public void unlockAll(Player player) {
        this.lootProgressMap.get((Object)player.m_20148_().toString()).treasureBags.forEach((treasureBagId, treasureBagData) -> treasureBagData.lootDataList.forEach(lootData -> {
            lootData.isUnlocked = true;
        }));
        this.sendMessageTo(player);
    }

    private void onLogged(OnPlayerLogged.Data data) {
        this.createDefaultProgress(data.player);
        this.sendMessageTo(data.player);
    }

    private void updateProgress(OnTreasureBagOpened.Data data) {
        boolean unlockedNewItems = false;
        TreasureBagData treasureBagData = this.get(data.player).get(data.treasureBag);
        for (ItemStack itemStack : data.generatedLoot) {
            String itemId = this.getItemId(itemStack);
            for (LootData lootData : treasureBagData.lootDataList) {
                if (!lootData.itemId.equals(itemId)) continue;
                unlockedNewItems |= !lootData.isUnlocked;
                lootData.unlock();
            }
        }
        if (unlockedNewItems) {
            this.sendMessageTo(data.player);
        }
    }

    private void createDefaultProgress(Player player) {
        LootContext context = TreasureBagItem.generateLootContext(player);
        for (TreasureBagItem item : TreasureBagItem.TREASURE_BAGS) {
            TreasureBagData data = this.get(player).get(item);
            for (LootPool lootPool : (List)POOLS.getOr((Object)item.getLootTable(), new ArrayList())) {
                for (LootPoolEntryContainer container : (LootPoolEntryContainer[])ENTRIES.getOr((Object)lootPool, (Object)new LootPoolEntryContainer[0])) {
                    LootItem lootItem = (LootItem)Utility.castIfPossible(LootItem.class, (Object)container);
                    if (lootItem == null) continue;
                    lootItem.m_6948_(itemStack -> {
                        String itemId = this.getItemId((ItemStack)itemStack);
                        if (data.lootDataList.stream().noneMatch(lootData -> lootData.itemId.equals(itemId))) {
                            data.lootDataList.add(new LootData(itemId, false, lootItem.f_79676_));
                        }
                    }, context);
                }
            }
            data.lootDataList.sort(Comparator.comparingInt(a -> -a.quality));
        }
    }

    private void sendMessageTo(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)this.get((Player)serverPlayer));
        }
    }

    private String getItemId(ItemStack itemStack) {
        String itemId = Utility.getRegistryString((Item)itemStack.m_41720_());
        if (itemId.equals("minecraft:book")) {
            return "minecraft:enchanted_book";
        }
        return itemId;
    }

    private LootProgressData get(Player player) {
        return this.lootProgressMap.computeIfAbsent(player.m_20148_().toString(), key -> new LootProgressData());
    }

    @AutoInstance
    public static class Handler {
        public Handler() {
            new OnPlayerLogged.Context(data -> Registries.getTreasureBagProgressManager().onLogged((OnPlayerLogged.Data)data)).addCondition((Condition)new Condition.IsServer());
            new OnTreasureBagOpened.Context(data -> Registries.getTreasureBagProgressManager().updateProgress((OnTreasureBagOpened.Data)((Object)data))).addCondition((Condition)new Condition.IsServer());
        }
    }
}

