/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GameStageTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = Registries.getLocation("game_state");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject jsonObject, EntityPredicate.Composite predicate, DeserializationContext conditions) {
        JsonElement stateElement = jsonObject.get("state_id");
        return new Instance(predicate, GameStage.convertIntegerToStage(stateElement.getAsInt()));
    }

    @SubscribeEvent
    public static void onStart(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            Registries.GAME_STATE_TRIGGER.trigger((ServerPlayer)event.getEntity(), GameStage.getCurrentStage());
        }
    }

    public void trigger(ServerPlayer player, GameStage stage) {
        this.m_66234_(player, instance -> instance.test(stage));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final GameStage stage;

        public Instance(EntityPredicate.Composite player, GameStage stage) {
            super(ID, player);
            this.stage = stage;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonObject = super.m_7683_(conditions);
            jsonObject.addProperty("state_id", (Number)this.stage.ordinal());
            return jsonObject;
        }

        public boolean test(GameStage stage) {
            return stage.ordinal() >= this.stage.ordinal();
        }
    }
}

