/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.undeadarmy.data.UndeadArmyInfo;
import com.majruszsdifficulty.undeadarmy.data.WaveDef;
import com.majruszsdifficulty.undeadarmy.data.WavesDef;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.BooleanConfig;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.data.JsonListener;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnDeath;
import com.mlib.gamemodifiers.contexts.OnLoot;
import com.mlib.gamemodifiers.contexts.OnServerTick;
import com.mlib.loot.LootHelper;
import com.mlib.math.Range;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.TickEvent;

@AutoInstance
public class Config
extends GameModifier {
    static ResourceLocation EXTRA_LOOT_ID = Registries.getLocation("undead_army/extra_mob_loot");
    private final BooleanConfig availability = new BooleanConfig(true);
    private final DoubleConfig waveDuration = new DoubleConfig(1200.0, new Range((Number)300.0, (Number)3600.0));
    private final DoubleConfig preparationDuration = new DoubleConfig(10.0, new Range((Number)4.0, (Number)30.0));
    private final DoubleConfig highlightDelay = new DoubleConfig(300.0, new Range((Number)30.0, (Number)3600.0));
    private final DoubleConfig extraSizePerPlayer = new DoubleConfig(0.5, new Range((Number)0.0, (Number)1.0));
    private final IntegerConfig armyRadius = new IntegerConfig(70, new Range((Number)35, (Number)140));
    private final IntegerConfig killRequirement = new IntegerConfig(75, new Range((Number)0, (Number)1000));
    private final Supplier<WavesDef> wavesDef = JsonListener.add((String)"undead_army", (ResourceLocation)Registries.getLocation("waves"), WavesDef.class, WavesDef::new);

    public Config() {
        super(Registries.Modifiers.UNDEAD_ARMY);
        new OnServerTick.Context(data -> Registries.getUndeadArmyManager().tick()).addCondition(data -> ((TickEvent.ServerTickEvent)data.event).phase == TickEvent.Phase.END).insertTo((GameModifier)this);
        new OnDeath.Context(this::updateKilledUndead).addCondition(data -> this.getRequiredKills() > 0).addCondition(data -> data.target.m_6336_() == MobType.f_21641_).addCondition(data -> !Registries.getUndeadArmyManager().isPartOfUndeadArmy((Entity)data.target)).addCondition(data -> data.attacker instanceof ServerPlayer).insertTo((GameModifier)this);
        new OnLoot.Context(this::giveExtraLoot).addCondition((Condition)new Condition.IsServer()).addCondition(OnLoot.HAS_DAMAGE_SOURCE).addCondition(data -> !data.context.getQueriedLootTableId().equals((Object)EXTRA_LOOT_ID)).addCondition(data -> {
            Mob mob;
            Entity patt3371$temp = data.entity;
            return patt3371$temp instanceof Mob && (mob = (Mob)patt3371$temp).m_6336_() == MobType.f_21641_;
        }).addCondition(data -> Registries.getUndeadArmyManager().isPartOfUndeadArmy(data.entity)).insertTo((GameModifier)this);
        this.addConfig((IConfigurable)this.availability.name("is_enabled").comment("Determines whether the Undead Army can spawn in any way.")).addConfig((IConfigurable)this.waveDuration.name("wave_duration").comment("Duration that players have to defeat a single wave (in seconds).")).addConfig((IConfigurable)this.preparationDuration.name("preparation_duration").comment("Duration before the next wave arrives (in seconds).")).addConfig((IConfigurable)this.highlightDelay.name("highlight_delay").comment("Duration before all mobs will be highlighted (in seconds).")).addConfig((IConfigurable)this.extraSizePerPlayer.name("extra_size_per_player").comment("Extra size ratio per each additional player on multiplayer (0.25 means ~25% bigger army per player).")).addConfig((IConfigurable)this.armyRadius.name("army_radius").comment("Radius, which determines how big is the raid circle (in blocks).")).addConfig((IConfigurable)this.killRequirement.name("kill_requirement").comment("Required amount of killed undead to start the Undead Army. (set to 0 if you want to disable this)"));
    }

    public boolean isEnabled() {
        return this.availability.isEnabled();
    }

    public int getWaveDuration() {
        return this.waveDuration.asTicks();
    }

    public int getPreparationDuration() {
        return this.preparationDuration.asTicks();
    }

    public float getSizeMultiplier(int playerCount) {
        return 1.0f + (float)Math.max(playerCount - 1, 0) * this.extraSizePerPlayer.asFloat();
    }

    public int getWavesNum() {
        return this.getWaves().size();
    }

    public int getArmyRadius() {
        return (Integer)this.armyRadius.get();
    }

    public int getHighlightDelay() {
        return this.highlightDelay.asTicks();
    }

    public int getRequiredKills() {
        return (Integer)this.killRequirement.get();
    }

    public int getSpawnRadius() {
        return this.getArmyRadius() - 15;
    }

    public WaveDef getWave(int waveIdx) {
        List<WaveDef> waves = this.getWaves();
        return waves.get(Mth.m_14045_((int)(waveIdx - 1), (int)0, (int)(waves.size() - 1)));
    }

    public List<WaveDef> getWaves() {
        return this.wavesDef.get().stream().filter(waveDef -> GameStage.atLeast(waveDef.gameStage)).toList();
    }

    private void updateKilledUndead(OnDeath.Data data) {
        ServerPlayer player = (ServerPlayer)data.attacker;
        CompoundTag tag = player.getPersistentData();
        UndeadArmyInfo info = new UndeadArmyInfo();
        info.read(tag);
        ++info.killedUndead;
        if (info.killedUndead >= this.getRequiredKills() && Registries.getUndeadArmyManager().tryToSpawn((Player)player)) {
            info.killedUndead = 0;
        } else if (info.killedUndead == this.getRequiredKills() - 3) {
            player.m_213846_((Component)Component.m_237115_((String)"majruszsdifficulty.undead_army.warning").m_130940_(ChatFormatting.DARK_PURPLE));
        }
        info.write(tag);
    }

    private void giveExtraLoot(OnLoot.Data data) {
        ObjectArrayList extraLoot = LootHelper.getLootTable((ResourceLocation)EXTRA_LOOT_ID).m_230922_(this.toExtraLootContext(data));
        data.generatedLoot.addAll(extraLoot);
    }

    private LootContext toExtraLootContext(OnLoot.Data data) {
        return new LootContext.Builder(data.level).m_78972_(LootContextParams.f_81460_, (Object)data.entity.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)data.entity).m_78972_(LootContextParams.f_81457_, (Object)data.damageSource).m_78984_(LootContextParams.f_81458_, (Object)data.killer).m_78975_(LootContextParamSets.f_81415_);
    }
}

