/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszsdifficulty.undeadarmy.Config;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.data.Direction;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.data.SerializableStructure;
import com.mlib.levels.LevelHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class UndeadArmyManager
extends SerializableStructure {
    public static final UndeadArmyManager NOT_LOADED = new UndeadArmyManager();
    final List<UndeadArmy> undeadArmies = new ArrayList<UndeadArmy>();
    final ServerLevel level;
    final Config config;

    public UndeadArmyManager(ServerLevel level, Config config) {
        this.level = level;
        this.config = config;
        this.define("undead_armies", () -> this.undeadArmies, this.undeadArmies::addAll, () -> new UndeadArmy(level, config));
    }

    private UndeadArmyManager() {
        this.level = null;
        this.config = null;
    }

    public boolean tryToSpawn(Player player) {
        return LevelHelper.isEntityOutside((Entity)player) && LevelHelper.isEntityIn((Entity)player, (ResourceKey)Level.f_46428_) && this.tryToSpawn(this.getAttackPosition(player), Optional.empty());
    }

    public boolean tryToSpawn(BlockPos position, Optional<Direction> direction) {
        return this.config.isEnabled() && this.level.m_46791_() != Difficulty.PEACEFUL && this.findNearestUndeadArmy(position) == null && this.undeadArmies.add(this.setupNewArmy(position, direction));
    }

    @Nullable
    public UndeadArmy findNearestUndeadArmy(BlockPos position) {
        UndeadArmy nearestArmy = null;
        double minDistance = Double.MAX_VALUE;
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            double distance;
            if (!undeadArmy.isInRange(position) || !((distance = undeadArmy.distanceTo(position)) < minDistance)) continue;
            nearestArmy = undeadArmy;
            minDistance = distance;
        }
        return nearestArmy;
    }

    public boolean isPartOfUndeadArmy(Entity entity) {
        return this.undeadArmies.stream().anyMatch(undeadArmy -> undeadArmy.isPartOfWave(entity));
    }

    void tick() {
        this.undeadArmies.forEach(UndeadArmy::tick);
        boolean hasAnyArmyFinished = this.undeadArmies.removeIf(UndeadArmy::hasFinished);
        if (hasAnyArmyFinished && this.undeadArmies.isEmpty()) {
            LevelHelper.setClearWeather((Level)this.level, (int)Utility.minutesToTicks((double)0.5));
        }
    }

    private UndeadArmy setupNewArmy(BlockPos position, Optional<Direction> direction) {
        UndeadArmy undeadArmy = new UndeadArmy(this.level, this.config);
        undeadArmy.start(position, direction.orElse((Direction)((Object)Random.nextRandom((Object[])Direction.values()))));
        return undeadArmy;
    }

    private BlockPos getAttackPosition(Player player) {
        int x = (int)player.m_20185_();
        int z = (int)player.m_20189_();
        return new BlockPos(x, this.level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z), z);
    }
}

