/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.components;

import com.majruszsdifficulty.goals.UndeadArmyAttackPositionGoal;
import com.majruszsdifficulty.goals.UndeadArmyForgiveTeammateGoal;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.components.IComponent;
import com.majruszsdifficulty.undeadarmy.data.Direction;
import com.majruszsdifficulty.undeadarmy.data.MobDef;
import com.majruszsdifficulty.undeadarmy.data.MobInfo;
import com.majruszsdifficulty.undeadarmy.data.Phase;
import com.majruszsdifficulty.undeadarmy.data.WaveDef;
import com.mlib.Random;
import com.mlib.entities.EntityHelper;
import com.mlib.items.ItemHelper;
import com.mlib.loot.LootHelper;
import com.mlib.math.VectorHelper;
import com.mlib.time.TimeHelper;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

record MobSpawner(UndeadArmy undeadArmy) implements IComponent
{
    @Override
    public void tick() {
        if (!TimeHelper.hasServerTicksPassed((int)20) || this.undeadArmy.phase.state != Phase.State.WAVE_ONGOING) {
            return;
        }
        MobInfo mobInfo = this.getNextMobToSpawn();
        if (mobInfo != null) {
            this.spawnMob(mobInfo);
        }
    }

    @Override
    public void onStateChanged() {
        if (this.undeadArmy.phase.state == Phase.State.WAVE_PREPARING) {
            this.generateMobList();
            this.undeadArmy.phase.healthTotal = 0;
        }
    }

    @Override
    public void onGameReload() {
        this.undeadArmy.mobsLeft.forEach(mobInfo -> {
            Entity patt1590$temp = mobInfo.toEntity(this.undeadArmy.level);
            if (patt1590$temp instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)patt1590$temp;
                this.addGoals(mob);
            }
        });
    }

    @Nullable
    private MobInfo getNextMobToSpawn() {
        return this.undeadArmy.mobsLeft.stream().filter(mobDef -> mobDef.uuid == null).findFirst().orElse(null);
    }

    private void spawnMob(MobInfo mobInfo) {
        Vec3 position = VectorHelper.subtract((Vec3)VectorHelper.vec3((BlockPos)mobInfo.position), (Vec3)new Vec3(0.0, 0.5, 0.0));
        Entity entity = EntityHelper.spawn(mobInfo.type, (Level)this.undeadArmy.level, (Vec3)position);
        if (!(entity instanceof PathfinderMob)) {
            this.undeadArmy.mobsLeft.remove((Object)mobInfo);
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        mobInfo.uuid = mob.m_20148_();
        this.updateWaveHealth(mobInfo);
        this.loadEquipment(mob, mobInfo);
        this.addGoals(mob);
        this.makePersistent(mob);
    }

    private void generateMobList() {
        float sizeMultiplier = this.undeadArmy.config.getSizeMultiplier(this.undeadArmy.participants.size());
        WaveDef waveDef = this.undeadArmy.config.getWave(this.undeadArmy.currentWave + 1);
        waveDef.mobDefs.forEach(mobDef -> {
            int totalCount = Random.roundRandomly((double)((float)mobDef.count * sizeMultiplier));
            for (int i = 0; i < totalCount; ++i) {
                this.addToPendingMobs((MobDef)((Object)mobDef), false);
            }
        });
        if (waveDef.boss != null) {
            this.addToPendingMobs(waveDef.boss, true);
        }
    }

    private void addToPendingMobs(MobDef def, boolean isBoss) {
        this.undeadArmy.mobsLeft.add(new MobInfo(def, this.getRandomSpawnPosition(), isBoss));
    }

    private void updateWaveHealth(MobInfo mobInfo) {
        this.undeadArmy.phase.healthTotal = (int)((float)this.undeadArmy.phase.healthTotal + mobInfo.getMaxHealth(this.undeadArmy.level));
    }

    private BlockPos getRandomSpawnPosition() {
        int z;
        Vec3 offset;
        int x;
        int y;
        int tries = 0;
        do {
            offset = this.buildOffset();
        } while ((y = this.undeadArmy.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x = this.undeadArmy.positionToAttack.m_123341_() + (int)offset.f_82479_, z = this.undeadArmy.positionToAttack.m_123343_() + (int)offset.f_82481_)) != this.undeadArmy.level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) && ++tries < 5);
        return new BlockPos(x, y, z);
    }

    private Vec3 buildOffset() {
        int spawnRadius = this.undeadArmy.config.getSpawnRadius();
        Direction direction = this.undeadArmy.direction;
        int x = direction.z != 0 ? 24 : 8;
        int y = 0;
        int z = direction.x != 0 ? 24 : 8;
        return VectorHelper.add((Vec3)new Vec3((double)(direction.x * spawnRadius), 0.0, (double)(direction.z * spawnRadius)), (Vec3)Random.getRandomVector3d((double)(-x), (double)x, (double)(-y), (double)y, (double)(-z), (double)z));
    }

    private void loadEquipment(PathfinderMob mob, MobInfo mobInfo) {
        LootHelper.getLootTable((ResourceLocation)mobInfo.equipment).m_230922_(LootHelper.toGiftContext((Entity)mob)).forEach(itemStack -> ItemHelper.equip((Mob)mob, (ItemStack)itemStack));
        Arrays.stream(EquipmentSlot.values()).forEach(slot -> mob.m_21409_(slot, 0.025f));
    }

    private void addGoals(PathfinderMob mob) {
        mob.f_21346_.m_25352_(11, (Goal)new UndeadArmyForgiveTeammateGoal(mob));
        mob.f_21345_.m_25352_(4, (Goal)new UndeadArmyAttackPositionGoal((Mob)mob, this.undeadArmy.positionToAttack));
    }

    private void makePersistent(PathfinderMob mob) {
        mob.m_21530_();
    }
}

