/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.config;

import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.contexts.OnConfigLoaded;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigHandler
extends ConfigGroup {
    final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    final ModConfig.Type type;
    ForgeConfigSpec configSpec = null;

    public ConfigHandler(ModConfig.Type type) {
        super(new IConfigurable[0]);
        this.type = type;
    }

    public void register(ModLoadingContext modLoadingContext) {
        this.build(this.builder);
        this.configSpec = this.builder.build();
        modLoadingContext.registerConfig(this.type, (IConfigSpec)this.configSpec);
        OnConfigLoaded.dispatch(this);
        if (this.type == ModConfig.Type.SERVER && this.configSpec.size() > 0) {
            this.registerHelpConfigSpec(modLoadingContext);
        }
    }

    public ModConfig.Type getType() {
        return this.type;
    }

    private void registerHelpConfigSpec(ModLoadingContext modLoadingContext) {
        String[] comments = new String[]{" Hello, Majrusz over here!", " Since one of 1.19.2 release, configs used by my mods are mostly server-side", " which means they are stored separately per world. Thanks to this change,", " configuration files are synchronised with other players on the server, which", " is crucial for some of the functionalities.", "  ", " Anyway, here are the exact locations for 'true' configuration files:", "   Singleplayer: %appdata%/saves/<world>/serverconfig", "   Multiplayer: <your server>/<world>/serverconfig", "  ", " If you have any questions or want to see some more configs, feel", " free to contact me on my Discord server! Hope to see you there :D"};
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment(comments).define("discord_url", (Object)"https://discord.gg/9UF774WcuW");
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
    }
}

