/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.enchantments;

import com.mlib.ObfuscationGetter;
import com.mlib.Utility;
import com.mlib.gamemodifiers.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.items.ItemHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CustomEnchantment
extends Enchantment {
    static final ObfuscationGetter.Field<Enchantment, EquipmentSlot[]> SLOTS = new ObfuscationGetter.Field(Enchantment.class, "f_44671_");
    static final ObfuscationGetter.Field<Enchantment, Enchantment.Rarity> RARITY = new ObfuscationGetter.Field(Enchantment.class, "f_44674_");
    static final ObfuscationGetter.Field<Enchantment, EnchantmentCategory> CATEGORY = new ObfuscationGetter.Field(Enchantment.class, "f_44672_");
    protected boolean isCurse = false;
    protected int maxLevel = 1;
    protected CostFormula minLevelCost = level -> 10;
    protected CostFormula maxLevelCost = level -> 50;

    protected CustomEnchantment() {
        super(null, null, null);
    }

    public int m_6586_() {
        return this.maxLevel;
    }

    public int m_6183_(int enchantmentLevel) {
        return this.minLevelCost.getCostLevel(enchantmentLevel);
    }

    public int m_6175_(int enchantmentLevel) {
        return this.maxLevelCost.getCostLevel(enchantmentLevel);
    }

    public boolean m_6081_(ItemStack itemStack) {
        return this.isEnabled() && super.m_6081_(itemStack);
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(itemStack);
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6591_() {
        return this.isCurse;
    }

    public boolean m_6589_() {
        return this.isCurse;
    }

    public CustomEnchantment slots(EquipmentSlot[] slots) {
        SLOTS.set(this, slots);
        return this;
    }

    public CustomEnchantment rarity(Enchantment.Rarity rarity) {
        RARITY.set(this, rarity);
        return this;
    }

    public CustomEnchantment category(EnchantmentCategory category) {
        CATEGORY.set(this, category);
        return this;
    }

    public CustomEnchantment curse() {
        this.isCurse = true;
        return this;
    }

    public CustomEnchantment maxLevel(int level) {
        this.maxLevel = level;
        return this;
    }

    public CustomEnchantment minLevelCost(CostFormula formula) {
        this.minLevelCost = formula;
        return this;
    }

    public CustomEnchantment maxLevelCost(CostFormula formula) {
        this.maxLevelCost = formula;
        return this;
    }

    public int getEnchantmentLevel(ItemStack itemStack) {
        return itemStack.getEnchantmentLevel((Enchantment)this);
    }

    public int getEnchantmentLevel(LivingEntity entity) {
        return EnchantmentHelper.m_44836_((Enchantment)this, (LivingEntity)entity);
    }

    public boolean hasEnchantment(ItemStack itemStack) {
        return this.getEnchantmentLevel(itemStack) > 0;
    }

    public boolean hasEnchantment(LivingEntity entity) {
        return this.getEnchantmentLevel(entity) > 0;
    }

    public boolean increaseEnchantmentLevel(ItemStack itemStack) {
        int enchantmentLevel = this.getEnchantmentLevel(itemStack);
        if (enchantmentLevel >= this.m_6586_()) {
            return false;
        }
        if (enchantmentLevel == 0) {
            this.enchantItem(itemStack, 1);
            return true;
        }
        this.setEnchantmentTag(itemStack, enchantmentLevel + 1);
        return true;
    }

    public boolean removeEnchantment(ItemStack itemStack) {
        if (this.getEnchantmentLevel(itemStack) == 0) {
            return false;
        }
        ListTag nbt = itemStack.m_41785_();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag enchantmentData = nbt.m_128728_(i);
            if (!enchantmentData.m_128461_("id").contains(Utility.getRegistryString(this))) continue;
            nbt.remove(i);
            break;
        }
        itemStack.m_41700_("Enchantments", (Tag)nbt);
        return true;
    }

    public int getEnchantmentSum(Iterable<ItemStack> itemStacks) {
        int sum = 0;
        for (ItemStack itemStack : itemStacks) {
            sum += this.getEnchantmentLevel(itemStack);
        }
        return sum;
    }

    public int getEnchantmentSum(LivingEntity livingEntity, EquipmentSlot[] slots) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (EquipmentSlot slotType : slots) {
            itemStackList.add(livingEntity.m_6844_(slotType));
        }
        return this.getEnchantmentSum(itemStackList);
    }

    public int getMatchingHandItemEnchantmentLevel(LivingEntity entity, Predicate<ItemStack> predicate) {
        return this.getEnchantmentLevel(ItemHelper.getMatchingHandItem(entity, predicate));
    }

    public ItemStack deduceUsedHandItem(LivingEntity entity) {
        return ItemHelper.getMatchingHandItem(entity, itemStack -> this.f_44672_.m_7454_(itemStack.m_41720_()));
    }

    public int getDeducedHandEnchantmentLevel(LivingEntity entity) {
        return this.getEnchantmentLevel(this.deduceUsedHandItem(entity));
    }

    protected boolean isEnabled() {
        return OnEnchantmentAvailabilityCheck.dispatch(this).isEnabled();
    }

    protected boolean isDisabled() {
        return !this.isEnabled();
    }

    private void enchantItem(ItemStack itemStack, int level) {
        itemStack.m_41663_((Enchantment)this, level);
    }

    private void setEnchantmentTag(ItemStack itemStack, int level) {
        ListTag nbt = itemStack.m_41785_();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag enchantmentData = nbt.m_128728_(i);
            String enchantmentID = enchantmentData.m_128461_("id");
            if (!enchantmentID.contains(ForgeRegistries.ENCHANTMENTS.getKey((Object)this).toString())) continue;
            enchantmentData.m_128405_("lvl", level);
            break;
        }
        itemStack.m_41700_("Enchantments", (Tag)nbt);
    }

    @FunctionalInterface
    protected static interface CostFormula {
        public int getCostLevel(int var1);
    }
}

