/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.entities;

import com.mlib.NetworkHandler;
import com.mlib.ObfuscationGetter;
import com.mlib.Utility;
import com.mlib.math.AABBHelper;
import com.mlib.math.AnyPos;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.RegistryObject;

public class EntityHelper {
    static final ObfuscationGetter.Field<ServerLevel, PersistentEntitySectionManager<Entity>> ENTITY_MANAGER = new ObfuscationGetter.Field(ServerLevel.class, "f_143244_");

    public static void cheatDeath(LivingEntity entity, float healthRatio, boolean shouldPlayEffects) {
        Level level;
        entity.m_21153_(entity.m_21233_() * healthRatio);
        if (shouldPlayEffects && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123767_, entity.m_20185_(), entity.m_20227_(0.75), entity.m_20189_(), 64, 0.25, 0.5, 0.25, 0.5);
            level2.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    public static boolean isOnCreativeMode(Player player) {
        return player.m_150110_().f_35937_;
    }

    public static boolean isOnSpectatorMode(Player player) {
        return player.m_5833_();
    }

    public static boolean isAnimal(@Nullable Entity entity) {
        return entity instanceof Animal;
    }

    public static boolean isHuman(Entity entity) {
        return entity instanceof Villager || entity instanceof WanderingTrader || entity instanceof Player || entity instanceof Witch || entity instanceof Pillager;
    }

    public static boolean isLoaded(ServerLevel level, UUID uuid) {
        return ENTITY_MANAGER.get(level).m_157550_(uuid);
    }

    public static double getHealthRatio(LivingEntity entity) {
        return Mth.m_14008_((double)(entity.m_21223_() / entity.m_21233_()), (double)0.0, (double)1.0);
    }

    public static double getMissingHealthRatio(LivingEntity entity) {
        return 1.0 - EntityHelper.getHealthRatio(entity);
    }

    public static float getWalkDistanceDelta(LivingEntity entity) {
        return entity.f_19787_ - entity.f_19867_;
    }

    public static void disableCurrentItem(Player player, double seconds) {
        player.m_36335_().m_41524_(player.m_21211_().m_41720_(), Utility.secondsToTicks(seconds));
        player.m_5810_();
        player.m_9236_().m_7605_((Entity)player, (byte)30);
    }

    public static boolean spawnExperience(Level level, Vec3 position, int experience) {
        return level.m_7967_((Entity)new ExperienceOrb(level, position.f_82479_, position.f_82480_, position.f_82481_, experience));
    }

    @Nullable
    public static <Type extends Entity> Type spawn(EntityType<Type> entityType, Level level, Consumer<Type> beforeEvent) {
        Entity entity = entityType.m_20615_(level);
        if (entity != null) {
            beforeEvent.accept(entity);
            if (!level.m_7967_(entity)) {
                return null;
            }
        }
        return (Type)entity;
    }

    @Nullable
    public static <Type extends Entity> Type spawn(RegistryObject<EntityType<Type>> entityType, Level level, Consumer<Type> beforeEvent) {
        return EntityHelper.spawn((EntityType)entityType.get(), level, beforeEvent);
    }

    @Nullable
    public static <Type extends Entity> Type spawn(EntityType<Type> entityType, Level level, Vec3 position) {
        return (Type)EntityHelper.spawn(entityType, level, (Type entity) -> entity.m_20219_(position));
    }

    @Nullable
    public static <Type extends Entity> Type spawn(RegistryObject<EntityType<Type>> entityType, Level level, Vec3 position) {
        return EntityHelper.spawn((EntityType)entityType.get(), level, position);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInBox(Class<EntityType> entityClass, ServerLevel level, Vec3 position, double sideLength, Predicate<EntityType> extraPredicate) {
        AABB axisAligned = AABBHelper.createInflatedAABB(position, sideLength / 2.0);
        return level.m_6443_(entityClass, axisAligned, extraPredicate);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInBox(Class<EntityType> entityClass, ServerLevel level, BlockPos blockPosition, double sideLength, Predicate<EntityType> extraPredicate) {
        return EntityHelper.getEntitiesInBox(entityClass, level, AnyPos.from(blockPosition).vec3(), sideLength, extraPredicate);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInBox(Class<EntityType> entityClass, ServerLevel level, Entity entity, double sideLength, Predicate<EntityType> extraPredicate) {
        return EntityHelper.getEntitiesInBox(entityClass, level, entity.m_20182_(), sideLength, extraPredicate);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInSphere(Class<EntityType> entityClass, ServerLevel level, Vec3 position, double radius, Predicate<EntityType> extraPredicate) {
        Predicate<Entity> distancePredicate = entity -> AnyPos.from(position).dist(entity.m_20182_()).doubleValue() <= radius;
        return EntityHelper.getEntitiesInBox(entityClass, level, position, radius * 2.0, distancePredicate.and(extraPredicate));
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInSphere(Class<EntityType> entityClass, ServerLevel level, BlockPos blockPosition, double radius, Predicate<EntityType> extraPredicate) {
        return EntityHelper.getEntitiesInSphere(entityClass, level, AnyPos.from(blockPosition).vec3(), radius, extraPredicate);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInSphere(Class<EntityType> entityClass, ServerLevel level, Entity entity, double radius, Predicate<EntityType> extraPredicate) {
        return EntityHelper.getEntitiesInSphere(entityClass, level, entity.m_20182_(), radius, extraPredicate);
    }

    public static void sendExtraClientGlowTicks(ServerPlayer player, Entity target, int ticks) {
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new NetworkHandler.EntityGlow(target, ticks));
    }
}

