/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers;

import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.entities.EntityHelper;
import com.mlib.gamemodifiers.Priority;
import com.mlib.gamemodifiers.data.ILevelData;
import com.mlib.gamemodifiers.data.IPositionData;
import com.mlib.gamemodifiers.data.ITickData;
import com.mlib.levels.LevelHelper;
import com.mlib.math.AnyPos;
import com.mlib.math.Range;
import com.mlib.time.TimeHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;

public class Condition<DataType>
extends ConfigGroup {
    final Predicate<DataType> predicate;
    Priority priority = Priority.NORMAL;
    boolean isNegated = false;
    boolean isConfigurable = false;

    public static <DataType> Condition<DataType> excludable(BooleanConfig availability) {
        return new Condition<Object>(data -> (Boolean)availability.getOrDefault()).priority(Priority.HIGHEST).configurable(true).addConfig(availability);
    }

    public static <DataType> Condition<DataType> excludable(boolean defaultValue) {
        BooleanConfig availability = new BooleanConfig(defaultValue);
        availability.name("is_enabled").comment("Specifies whether this is enabled.");
        return Condition.excludable(availability);
    }

    public static <DataType> Condition<DataType> excludable() {
        return Condition.excludable(true);
    }

    public static <DataType> Condition<DataType> chance(DoubleConfig chance) {
        return new Condition<Object>(data -> Random.tryChance((Double)chance.getOrDefault())).priority(Priority.HIGH).configurable(true).addConfig(chance);
    }

    public static <DataType> Condition<DataType> chance(double defaultChance) {
        DoubleConfig chance = new DoubleConfig(defaultChance, Range.CHANCE);
        chance.name("chance").comment("Chance for this to happen.");
        return Condition.chance(chance);
    }

    public static <DataType extends ILevelData & IPositionData> Condition<DataType> chanceCRD(DoubleConfig chance, boolean defaultScaledByCRD) {
        BooleanConfig scaledByCRD = new BooleanConfig(defaultScaledByCRD);
        Predicate<ILevelData> predicate = data -> {
            double multiplier = 1.0;
            if (scaledByCRD.isEnabled() && data.getLevel() != null) {
                multiplier *= LevelHelper.getClampedRegionalDifficultyAt(data.getLevel(), AnyPos.from(((IPositionData)((Object)data)).getPosition()).block());
            }
            return Random.tryChance(multiplier * (Double)chance.getOrDefault());
        };
        return ((Condition)new Condition<ILevelData>(predicate).priority(Priority.HIGH).configurable(true).addConfig(chance)).addConfig(scaledByCRD.name("scaled_by_crd").comment("Specifies whether the chance should be scaled by Clamped Regional Difficulty."));
    }

    public static <DataType extends ILevelData & IPositionData> Condition<DataType> chanceCRD(double defaultChance, boolean defaultScaledByCRD) {
        DoubleConfig chance = new DoubleConfig(defaultChance, Range.CHANCE);
        chance.name("chance").comment("Chance for this to happen.");
        return Condition.chanceCRD(chance, defaultScaledByCRD);
    }

    public static <DataType> Condition<DataType> isLivingBeing(Function<DataType, Entity> entity) {
        return new Condition<Object>(data -> EntityHelper.isAnimal((Entity)entity.apply(data)) || EntityHelper.isHuman((Entity)entity.apply(data)));
    }

    public static <DataType> Condition<DataType> predicate(Predicate<DataType> predicate) {
        return new Condition<DataType>(predicate).priority(Priority.LOW);
    }

    public static <DataType> Condition<DataType> predicate(Supplier<Boolean> check) {
        return new Condition<Object>(data -> (Boolean)check.get()).priority(Priority.LOW);
    }

    public static <DataType> Condition<DataType> cooldown(DoubleConfig cooldown, Dist distribution) {
        Predicate<Double> predicate = distribution == Dist.CLIENT ? TimeHelper::hasClientSecondsPassed : TimeHelper::hasServerSecondsPassed;
        return new Condition<Object>(data -> predicate.test((Double)cooldown.getOrDefault())).priority(Priority.HIGH).configurable(true).addConfig(cooldown);
    }

    public static <DataType> Condition<DataType> cooldown(double defaultSeconds, Dist distribution) {
        DoubleConfig cooldown = new DoubleConfig(defaultSeconds, new Range<Double>(0.1, 300.0));
        cooldown.name("cooldown").comment("Cooldown in seconds before it happens.");
        return Condition.cooldown(cooldown, distribution);
    }

    public static <DataType> Condition<DataType> cooldown(int defaultTicks, Dist distribution) {
        return Condition.cooldown(Utility.ticksToSeconds(defaultTicks), distribution);
    }

    public static <DataType> Condition<DataType> hasEnchantment(Supplier<? extends Enchantment> enchantment, Function<DataType, LivingEntity> entity) {
        return new Condition<Object>(data -> entity.apply(data) != null && EnchantmentHelper.m_44836_((Enchantment)((Enchantment)enchantment.get()), (LivingEntity)((LivingEntity)entity.apply(data))) > 0);
    }

    public static <DataType> Condition<DataType> hasEnchantment(Enchantment enchantment, Function<DataType, LivingEntity> entity) {
        return Condition.hasEnchantment(() -> enchantment, entity);
    }

    public static <DataType> Condition<DataType> hasEffect(Supplier<? extends MobEffect> effect, Function<DataType, LivingEntity> entity) {
        return new Condition<Object>(data -> entity.apply(data) != null && ((LivingEntity)entity.apply(data)).m_21023_((MobEffect)effect.get()));
    }

    public static <DataType> Condition<DataType> hasEffect(MobEffect effect, Function<DataType, LivingEntity> entity) {
        return Condition.hasEffect(() -> effect, entity);
    }

    public static <DataType extends ILevelData> Condition<DataType> isServer() {
        return new Condition<ILevelData>(data -> data.getLevel() instanceof ServerLevel).priority(Priority.HIGH);
    }

    public static <DataType> Condition<DataType> isShiftKeyDown(Function<DataType, Player> player) {
        return new Condition<Object>(data -> player.apply(data) != null && ((Player)player.apply(data)).m_6144_()).priority(Priority.HIGH);
    }

    public static <DataType> Condition<DataType> isOnGround(Function<DataType, Entity> entity) {
        return new Condition<Object>(data -> entity.apply(data) != null && ((Entity)entity.apply(data)).m_20096_()).priority(Priority.HIGH);
    }

    public static <DataType extends ITickData> Condition<DataType> isEndPhase() {
        return new Condition<ITickData>(data -> data.getPhase() == TickEvent.Phase.END);
    }

    public static <DataType> Condition<DataType> armorDependentChance(Map<EquipmentSlot, Double> chances, Function<DataType, LivingEntity> entity) {
        HashMap<EquipmentSlot, DoubleConfig> multipliers = new HashMap<EquipmentSlot, DoubleConfig>();
        ConfigGroup group = new ConfigGroup(new IConfigurable[0]);
        for (EquipmentSlot slot : EquipmentSlots.ARMOR) {
            DoubleConfig config = new DoubleConfig(chances.get(slot), Range.CHANCE);
            multipliers.put(slot, config);
            group.addConfig(config.name(String.format("%s_multiplier", slot.m_20751_())));
        }
        return new Condition<Object>(data -> {
            double chance = 1.0;
            for (EquipmentSlot slot : multipliers.keySet()) {
                DoubleConfig config = (DoubleConfig)multipliers.get(slot);
                ItemStack itemStack = ((LivingEntity)entity.apply(data)).m_6844_(slot);
                if (itemStack.m_41619_() || !itemStack.m_41638_(slot).containsKey((Object)Attributes.f_22284_)) continue;
                chance *= ((Double)config.getOrDefault()).doubleValue();
            }
            return Random.tryChance(chance);
        }).configurable(true).addConfig(group.name("ArmorChanceMultipliers").comment("Chance multipliers for each armor piece.\nFor instance 'head_multiplier = 0.8' makes the final chance 20% lower if mob has any helmet."));
    }

    public static <DataType> Condition<DataType> armorDependentChance(double headChance, double chestChance, double legsChance, double feetChance, Function<DataType, LivingEntity> entity) {
        return Condition.armorDependentChance(Map.of(EquipmentSlot.HEAD, headChance, EquipmentSlot.CHEST, chestChance, EquipmentSlot.LEGS, legsChance, EquipmentSlot.FEET, feetChance), entity);
    }

    public static <DataType> Condition<DataType> armorDependentChance(double chance, Function<DataType, LivingEntity> entity) {
        return Condition.armorDependentChance(chance, chance, chance, chance, entity);
    }

    public Condition(Predicate<DataType> predicate) {
        super(new IConfigurable[0]);
        this.predicate = predicate;
    }

    @Override
    public Condition<DataType> addConfig(IConfigurable config) {
        super.addConfig(config);
        return this;
    }

    @Override
    public Condition<DataType> addConfigs(IConfigurable ... configs) {
        super.addConfigs(configs);
        return this;
    }

    public Condition<DataType> configurable(boolean isConfigurable) {
        this.isConfigurable = isConfigurable;
        return this;
    }

    public Condition<DataType> negate() {
        this.isNegated = !this.isNegated;
        return this;
    }

    public Condition<DataType> priority(Priority priority) {
        this.priority = priority;
        return this;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public boolean isConfigurable() {
        return this.isConfigurable;
    }

    public boolean check(DataType data) {
        return this.isNegated ^ this.predicate.test(data);
    }
}

