/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers;

import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.Priority;
import com.mlib.gamemodifiers.data.IProfilerData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.util.profiling.InactiveProfiler;

public class Contexts<DataType> {
    static final Map<Class<?>, Contexts<?>> CONTEXTS = Collections.synchronizedMap(new HashMap());
    final List<Context<DataType>> contexts = new ArrayList<Context<DataType>>();
    boolean isSorted = true;

    private Contexts() {
    }

    public static <DataType> Contexts<DataType> get(Class<DataType> clazz) {
        return CONTEXTS.computeIfAbsent(clazz, key -> new Contexts());
    }

    public static Stream<Contexts<?>> get() {
        return CONTEXTS.values().stream();
    }

    public synchronized Context<DataType> add(Consumer<DataType> consumer) {
        Context<DataType> context = new Context<DataType>(consumer);
        this.contexts.add(context);
        this.isSorted = false;
        return context;
    }

    public DataType dispatch(DataType data) {
        InactiveProfiler inactiveProfiler;
        if (data instanceof IProfilerData) {
            IProfilerData profilerData = (IProfilerData)data;
            inactiveProfiler = profilerData.getProfiler();
        } else {
            inactiveProfiler = InactiveProfiler.f_18554_;
        }
        InactiveProfiler profiler = inactiveProfiler;
        profiler.m_6180_(data.getClass().getName());
        this.tryToSort();
        this.forEach(context -> context.accept(data));
        profiler.m_7238_();
        return data;
    }

    public void forEach(Consumer<Context<DataType>> consumer) {
        this.contexts.forEach(consumer);
    }

    public synchronized void tryToSort() {
        if (!this.isSorted) {
            this.contexts.sort((left, right) -> Priority.COMPARATOR.compare(left.priority, right.priority));
            this.contexts.forEach(Context::tryToSort);
            this.isSorted = true;
        }
    }
}

