/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.Contexts;
import com.mlib.gamemodifiers.data.IEntityData;
import com.mlib.items.ItemHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ToolActions;

public class OnExtraFishingLootCheck {
    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    public static Data dispatch(List<ItemStack> drops, Player player) {
        return Contexts.get(Data.class).dispatch(new Data(drops, player));
    }

    public static class Data
    implements IEntityData {
        public final List<ItemStack> drops;
        public final List<ItemStack> extraLoot = new ArrayList<ItemStack>();
        public final Player player;
        public final ItemStack fishingRod;
        public int extraExperience = 0;
        public int extraRodDamage = 0;

        public Data(List<ItemStack> drops, Player player) {
            this.drops = Collections.unmodifiableList(drops);
            this.player = player;
            this.fishingRod = ItemHelper.getMatchingHandItem((LivingEntity)player, Data::isFishingRod);
        }

        public LootParams generateLootParams() {
            return new LootParams.Builder(this.getServerLevel()).m_287286_(LootContextParams.f_81463_, (Object)this.fishingRod).m_287239_(this.player.m_36336_()).m_287286_(LootContextParams.f_81460_, (Object)this.player.m_20182_()).m_287235_(LootContextParamSets.f_81414_);
        }

        public boolean isExtraLootEmpty() {
            return this.extraLoot.isEmpty();
        }

        private static boolean isFishingRod(ItemStack itemStack) {
            return itemStack.m_41720_().canPerformAction(itemStack, ToolActions.FISHING_ROD_CAST);
        }

        @Override
        public Entity getEntity() {
            return this.player;
        }
    }
}

