/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.google.gson.JsonObject;
import com.mlib.ObfuscationGetter;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.Contexts;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class OnLootTableCustomLoad {
    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    public static Data dispatch(ResourceLocation name, LootTable table, JsonObject jsonObject) {
        return Contexts.get(Data.class).dispatch(new Data(name, table, jsonObject));
    }

    public static class Data {
        static final ObfuscationGetter.Field<LootTable, List<LootPool>> POOLS = new ObfuscationGetter.Field(LootTable.class, "f_79109_");
        static final ObfuscationGetter.Field<LootPool, LootPoolEntryContainer[]> ENTRIES = new ObfuscationGetter.Field(LootPool.class, "f_79023_");
        static final ObfuscationGetter.Field<LootPool.Builder, String> NAME = new ObfuscationGetter.Field(LootPool.Builder.class, "f_79071_");
        public final ResourceLocation name;
        public final LootTable table;
        public final List<LootPool> pools;
        public final JsonObject jsonObject;

        public Data(ResourceLocation name, LootTable table, JsonObject jsonObject) {
            this.name = name;
            this.table = table;
            this.pools = POOLS.get(table);
            this.jsonObject = jsonObject;
        }

        public void addEntry(int poolId, Item item, int weight, int quality, LootItemCondition.Builder ... conditions) {
            LootPool lootPool = this.pools.get(poolId);
            LootPoolEntryContainer[] entries = ENTRIES.get(lootPool);
            assert (entries != null);
            LootPoolEntryContainer[] newEntries = new LootPoolEntryContainer[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            LootPoolSingletonContainer.Builder builder = LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79711_(quality);
            for (LootItemCondition.Builder condition : conditions) {
                builder.m_79080_(condition);
            }
            newEntries[entries.length] = builder.m_7512_();
            ENTRIES.set(lootPool, newEntries);
        }

        public int addPool() {
            LootPool.Builder builder = LootPool.m_79043_();
            NAME.set(builder, String.format("custom#%s%d", this.name.toString(), this.pools.size()));
            this.pools.add(builder.m_79082_());
            return this.pools.size() - 1;
        }
    }
}

