/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.Contexts;
import com.mlib.gamemodifiers.data.IEntityData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnSpawned {
    static final List<DataSafe> CLIENT_PENDING_LIST = new ArrayList<DataSafe>();
    static final List<DataSafe> SERVER_PENDING_LIST = new ArrayList<DataSafe>();

    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    public static Context<DataSafe> listenSafe(Consumer<DataSafe> consumer) {
        return Contexts.get(DataSafe.class).add(consumer);
    }

    @SubscribeEvent
    public static void onSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Contexts.get(Data.class).dispatch(new Data(entity2, event.loadedFromDisk()));
        List<DataSafe> list = entity2.m_9236_().f_46443_ ? CLIENT_PENDING_LIST : SERVER_PENDING_LIST;
        list.add(new DataSafe(entity2, event.loadedFromDisk()));
    }

    @SubscribeEvent
    public static void onClientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        OnSpawned.handle(CLIENT_PENDING_LIST);
    }

    @SubscribeEvent
    public static void onServerTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        OnSpawned.handle(SERVER_PENDING_LIST);
    }

    public static <DataType extends Data> Condition<DataType> isNotLoadedFromDisk() {
        return new Condition<Data>(data -> !data.loadedFromDisk);
    }

    public static <DataType extends Data> Condition<DataType> is(Class<?> ... classes) {
        return new Condition<Data>(data -> Arrays.stream(classes).anyMatch(clazz -> data.target.getClass().equals(clazz)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handle(List<DataSafe> pendingList) {
        ArrayList<DataSafe> list;
        List<DataSafe> list2 = pendingList;
        synchronized (list2) {
            list = new ArrayList<DataSafe>(pendingList);
            pendingList.clear();
        }
        list.forEach(data -> {
            if (data.target.isAddedToWorld()) {
                Contexts.get(DataSafe.class).dispatch((DataSafe)data);
            }
        });
    }

    public static class Data
    implements IEntityData {
        public final LivingEntity target;
        public final boolean loadedFromDisk;

        public Data(LivingEntity target, boolean loadedFromDisk) {
            this.target = target;
            this.loadedFromDisk = loadedFromDisk;
        }

        @Override
        public Entity getEntity() {
            return this.target;
        }
    }

    public static class DataSafe
    extends Data {
        public DataSafe(LivingEntity target, boolean loadedFromDisk) {
            super(target, loadedFromDisk);
        }
    }
}

