/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.itemsets;

import com.mlib.itemsets.ItemSet;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;

public class BonusData {
    final ICondition condition;
    final String keyId;
    final IRequirementFormat requirementFormat;
    final Object[] parameters;

    public static ICondition requiredItems(int count) {
        return (itemSet, entity) -> itemSet.countEquippedItems(entity) >= count;
    }

    public static IRequirementFormat requiredItemsFormat(int count) {
        return (itemSet, entity) -> Component.m_237110_((String)"%1$s/%2$s", (Object[])new Object[]{count, itemSet.getTotalItemsCount()});
    }

    public BonusData(ICondition condition, String keyId, IRequirementFormat requirementFormat, Object ... parameters) {
        this.condition = condition;
        this.keyId = keyId;
        this.requirementFormat = requirementFormat;
        this.parameters = parameters;
    }

    public BonusData(int requiredItems, String keyId, Object ... parameters) {
        this(BonusData.requiredItems(requiredItems), keyId, BonusData.requiredItemsFormat(requiredItems), parameters);
    }

    public boolean isConditionMet(ItemSet itemSet, LivingEntity entity) {
        return this.condition.check(itemSet, entity);
    }

    public MutableComponent buildTranslatedRequirements(ItemSet itemSet, boolean isConditionMet) {
        ChatFormatting chatFormatting = isConditionMet ? itemSet.getChatFormatting() : ChatFormatting.DARK_GRAY;
        return this.requirementFormat.build(itemSet, this).m_130940_(chatFormatting);
    }

    public MutableComponent buildTranslatedName(ItemSet itemSet, boolean isConditionMet) {
        ChatFormatting chatFormatting = isConditionMet ? itemSet.getChatFormatting() : ChatFormatting.DARK_GRAY;
        Object[] params = Arrays.stream(this.parameters).map(parameter -> {
            if (parameter instanceof MutableComponent) {
                MutableComponent component = (MutableComponent)parameter;
                return component.m_130940_(chatFormatting);
            }
            return Component.m_237113_((String)parameter.toString()).m_130940_(chatFormatting);
        }).toArray();
        return Component.m_237110_((String)this.keyId, (Object[])params).m_130940_(isConditionMet ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY);
    }

    @FunctionalInterface
    public static interface ICondition {
        public boolean check(ItemSet var1, LivingEntity var2);
    }

    @FunctionalInterface
    public static interface IRequirementFormat {
        public MutableComponent build(ItemSet var1, BonusData var2);
    }
}

