/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.itemsets;

import com.mlib.client.ClientHelper;
import com.mlib.itemsets.ItemSet;
import com.mlib.text.TextHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ItemSetTooltip {
    static final ChatFormatting DISABLED_FORMAT = ChatFormatting.DARK_GRAY;
    static final ChatFormatting HINT_FORMAT = ChatFormatting.GRAY;
    static final String ITEM_TITLE_KEY = "mlib.item_sets.item_title";
    static final String ITEM_KEY = "mlib.item_sets.item";
    static final String BONUS_TITLE_KEY = "mlib.item_sets.bonus_title";
    static final String BONUS_KEY = "mlib.item_sets.bonus";

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        @Nullable Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        List tooltip = event.getToolTip();
        if (player == null || ItemSetTooltip.isNotPartOfAnySet(itemStack)) {
            return;
        }
        if (!ClientHelper.isShiftDown()) {
            TextHelper.addEmptyLine(tooltip);
            TextHelper.addMoreDetailsText(tooltip);
            return;
        }
        for (ItemSet itemSet : ItemSet.ITEM_SETS) {
            if (!itemSet.isPartOfSet(itemStack)) continue;
            TextHelper.addEmptyLine(tooltip);
            ItemSetTooltip.addItemList(tooltip, itemSet, player);
            TextHelper.addEmptyLine(tooltip);
            ItemSetTooltip.addBonusList(tooltip, itemSet, player);
        }
    }

    private static boolean isNotPartOfAnySet(ItemStack itemStack) {
        return ItemSet.ITEM_SETS.stream().noneMatch(set -> set.isPartOfSet(itemStack));
    }

    private static void addItemList(List<Component> tooltip, ItemSet itemSet, Player player) {
        MutableComponent title = Component.m_237110_((String)ITEM_TITLE_KEY, (Object[])new Object[]{itemSet.getTranslatedName(), itemSet.countEquippedItems((LivingEntity)player), itemSet.getTotalItemsCount()});
        tooltip.add((Component)title.m_130940_(HINT_FORMAT));
        itemSet.getItems().forEach(item -> {
            ChatFormatting chatFormatting = item.isEquipped((LivingEntity)player) ? itemSet.getChatFormatting() : DISABLED_FORMAT;
            tooltip.add((Component)Component.m_237110_((String)ITEM_KEY, (Object[])new Object[]{item.getTranslatedName()}).m_130940_(chatFormatting));
        });
    }

    private static void addBonusList(List<Component> tooltip, ItemSet itemSet, Player player) {
        MutableComponent title = Component.m_237110_((String)BONUS_TITLE_KEY, (Object[])new Object[]{itemSet.getTranslatedName()});
        tooltip.add((Component)title.m_130940_(HINT_FORMAT));
        itemSet.getBonuses().forEach(bonus -> {
            boolean isConditionMet = bonus.isConditionMet(itemSet, (LivingEntity)player);
            ChatFormatting chatFormatting = isConditionMet ? itemSet.getChatFormatting() : ChatFormatting.DARK_GRAY;
            MutableComponent component = Component.m_237110_((String)BONUS_KEY, (Object[])new Object[]{bonus.buildTranslatedRequirements(itemSet, isConditionMet), bonus.buildTranslatedName(itemSet, isConditionMet)}).m_130940_(chatFormatting);
            tooltip.add((Component)component);
        });
    }
}

