/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.mixin;

import com.mlib.gamemodifiers.contexts.OnEntitySignalCheck;
import com.mlib.gamemodifiers.contexts.OnEntitySignalReceived;
import com.mlib.mixin.MixinEntity;
import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class MixinPlayer
extends MixinEntity {
    VibrationSystem.User mlibVibrationUser;
    VibrationSystem.Data mlibVibrationData;
    DynamicGameEventListener<VibrationSystem.Listener> mlibVibrationListener;

    @Shadow(aliases={"this$0"})
    @Inject(method={"<init> (Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;FLcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void constructor(Level level, BlockPos position, float rot, GameProfile profile, CallbackInfo callback) {
        Player player = (Player)this;
        this.mlibVibrationUser = new Config(player);
        this.mlibVibrationData = new VibrationSystem.Data();
        this.mlibVibrationListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener(new VibrationSystem(){

            public VibrationSystem.Data m_280002_() {
                return MixinPlayer.this.mlibVibrationData;
            }

            public VibrationSystem.User m_280445_() {
                return MixinPlayer.this.mlibVibrationUser;
            }
        }));
    }

    @Shadow(aliases={"this$0"})
    @Inject(method={"tick ()V"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo callback) {
        Player player = (Player)this;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            VibrationSystem.Ticker.m_280259_((Level)level2, (VibrationSystem.Data)this.mlibVibrationData, (VibrationSystem.User)this.mlibVibrationUser);
        }
    }

    @Override
    public void updateListeners(BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        Player player = (Player)this;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            consumer.accept(this.mlibVibrationListener, level2);
        }
    }

    public static class Config
    implements VibrationSystem.User {
        final Player player;
        final PositionSource positionSource;

        Config(Player player) {
            this.player = player;
            this.positionSource = new EntityPositionSource((Entity)player, player.m_20192_());
        }

        public int m_280351_() {
            return 16;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280080_(ServerLevel level, BlockPos position, GameEvent event, GameEvent.Context context) {
            return OnEntitySignalCheck.dispatch(level, position, this.player).shouldListen();
        }

        public void m_280271_(ServerLevel level, BlockPos position, GameEvent event, @Nullable Entity owner, @Nullable Entity ownersProjectile, float distance) {
            OnEntitySignalReceived.dispatch(level, position, this.player, owner, ownersProjectile, distance);
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }
    }
}

