/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.particles;

import com.mlib.Random;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public abstract class ConfigurableParticle
extends TextureSheetParticle {
    protected IFormula<Double> xdFormula = xd -> xd * (this.f_107218_ ? 0.5 : 0.95);
    protected IFormula<Double> ydFormula = yd -> yd - (this.f_107218_ ? 0.0 : 0.0375);
    protected IFormula<Double> zdFormula = zd -> zd * (this.f_107218_ ? 0.5 : 0.95);
    protected IFormula<Float> alphaFormula = alpha -> alpha;
    protected IFormula<Float> scaleFormula = lifeRatio -> Float.valueOf(1.0f - 0.5f * lifeRatio.floatValue());
    protected RotationFormula rotationFormula = (camera, scaleFactor) -> {
        if (this.f_107231_ == 0.0f) {
            return camera.m_253121_();
        }
        return new Quaternionf((Quaternionfc)camera.m_253121_()).rotateZ(Mth.m_14179_((float)scaleFactor, (float)this.f_107204_, (float)this.f_107231_));
    };
    protected boolean renderUpwardsWhenOnGround = false;
    protected float yOffset = 0.0f;

    public ConfigurableParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ = this.xdFormula.apply(this.f_107215_);
            this.f_107216_ = this.ydFormula.apply(this.f_107216_);
            this.f_107217_ = this.zdFormula.apply(this.f_107217_);
            this.f_107230_ = this.alphaFormula.apply(Float.valueOf(this.f_107230_)).floatValue();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float scaleFactor) {
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)scaleFactor, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)scaleFactor, (double)(this.f_107210_ + (double)this.yOffset), (double)(this.f_107213_ + (double)this.yOffset)) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)scaleFactor, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternion = this.rotationFormula.apply(camera, scaleFactor);
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(scaleFactor);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(scaleFactor);
        vertexConsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public float m_5902_(float scaleFactor) {
        return this.f_107663_ * this.scaleFormula.apply(Float.valueOf(((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_)).floatValue();
    }

    public void setRenderUpwardsWhenOnGround() {
        Quaternionf groundRotation = Axis.f_252529_.m_252961_(1.5707964f).rotateZ((float)Random.nextInt(0, 3) * 1.5707964f);
        RotationFormula defaultFormula = this.rotationFormula;
        this.renderUpwardsWhenOnGround = true;
        this.rotationFormula = (camera, scaleFactor) -> this.renderUpwardsWhenOnGround && this.f_107218_ ? groundRotation : defaultFormula.apply(camera, scaleFactor);
    }

    @FunctionalInterface
    public static interface IFormula<Type> {
        public Type apply(Type var1);
    }

    @FunctionalInterface
    public static interface RotationFormula {
        public Quaternionf apply(Camera var1, float var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class SimpleFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;
        private final IInstanceFactory instanceFactory;

        public SimpleFactory(SpriteSet sprite, IInstanceFactory instanceFactory) {
            this.spriteSet = sprite;
            this.instanceFactory = instanceFactory;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return this.instanceFactory.createInstance(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }

        @FunctionalInterface
        public static interface IInstanceFactory {
            public ConfigurableParticle createInstance(ClientLevel var1, double var2, double var4, double var6, double var8, double var10, double var12, SpriteSet var14);
        }
    }
}

