/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty;

import com.majruszsdifficulty.CreativeModeTabs;
import com.majruszsdifficulty.GameDataSaver;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.PacketHandler;
import com.majruszsdifficulty.RegistriesClient;
import com.majruszsdifficulty.blocks.EndShardOre;
import com.majruszsdifficulty.blocks.EnderiumBlock;
import com.majruszsdifficulty.blocks.InfestedEndStone;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.effects.BleedingImmunityEffect;
import com.majruszsdifficulty.entities.BlackWidowEntity;
import com.majruszsdifficulty.entities.CerberusEntity;
import com.majruszsdifficulty.entities.CreeperlingEntity;
import com.majruszsdifficulty.entities.CursedArmorEntity;
import com.majruszsdifficulty.entities.TankEntity;
import com.majruszsdifficulty.items.BadOmenPotionItem;
import com.majruszsdifficulty.items.BandageItem;
import com.majruszsdifficulty.items.CerberusFangItem;
import com.majruszsdifficulty.items.ClothItem;
import com.majruszsdifficulty.items.EndShardItem;
import com.majruszsdifficulty.items.EndShardLocatorItem;
import com.majruszsdifficulty.items.EnderPouchItem;
import com.majruszsdifficulty.items.EnderiumArmorItem;
import com.majruszsdifficulty.items.EnderiumAxeItem;
import com.majruszsdifficulty.items.EnderiumHoeItem;
import com.majruszsdifficulty.items.EnderiumIngotItem;
import com.majruszsdifficulty.items.EnderiumPickaxeItem;
import com.majruszsdifficulty.items.EnderiumShovelItem;
import com.majruszsdifficulty.items.EnderiumSmithingTemplateItem;
import com.majruszsdifficulty.items.EnderiumSwordItem;
import com.majruszsdifficulty.items.FakeItem;
import com.majruszsdifficulty.items.GoldenBandageItem;
import com.majruszsdifficulty.items.RecallPotionItem;
import com.majruszsdifficulty.items.SoulJarItem;
import com.majruszsdifficulty.items.TatteredArmorItem;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.majruszsdifficulty.items.UndeadBattleStandardItem;
import com.majruszsdifficulty.items.WitherSwordItem;
import com.majruszsdifficulty.loot.CurseRandomlyFunction;
import com.majruszsdifficulty.treasurebags.TreasureBagManager;
import com.majruszsdifficulty.treasurebags.TreasureBagProgressManager;
import com.majruszsdifficulty.triggers.BandageTrigger;
import com.majruszsdifficulty.triggers.GameStageTrigger;
import com.majruszsdifficulty.triggers.TreasureBagTrigger;
import com.majruszsdifficulty.undeadarmy.UndeadArmyManager;
import com.mlib.Utility;
import com.mlib.annotations.AnnotationHandler;
import com.mlib.config.ConfigHandler;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.registries.RegistryHelper;
import com.mlib.triggers.BasicTrigger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class Registries {
    private static final RegistryHelper HELPER = new RegistryHelper("majruszsdifficulty");
    static final DeferredRegister<Block> BLOCKS;
    static final DeferredRegister<Item> ITEMS;
    static final DeferredRegister<EntityType<?>> ENTITY_TYPES;
    static final DeferredRegister<MobEffect> MOB_EFFECTS;
    static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES;
    static final DeferredRegister<SoundEvent> SOUNDS_EVENTS;
    static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS;
    static final DeferredRegister<Potion> POTIONS;
    static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final RegistryObject<EntityType<CreeperlingEntity>> CREEPERLING;
    public static final RegistryObject<EntityType<TankEntity>> TANK;
    public static final RegistryObject<EntityType<CursedArmorEntity>> CURSED_ARMOR;
    public static final RegistryObject<EntityType<CerberusEntity>> CERBERUS;
    public static final RegistryObject<EntityType<BlackWidowEntity>> BLACK_WIDOW;
    public static final RegistryObject<BandageItem> BANDAGE;
    public static final RegistryObject<GoldenBandageItem> GOLDEN_BANDAGE;
    public static final RegistryObject<ClothItem> CLOTH;
    public static final RegistryObject<UndeadBattleStandardItem> BATTLE_STANDARD;
    public static final RegistryObject<TatteredArmorItem> TATTERED_HELMET;
    public static final RegistryObject<TatteredArmorItem> TATTERED_CHESTPLATE;
    public static final RegistryObject<TatteredArmorItem> TATTERED_LEGGINGS;
    public static final RegistryObject<TatteredArmorItem> TATTERED_BOOTS;
    public static final RegistryObject<CerberusFangItem> CERBERUS_FANG;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_HELMET;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_CHESTPLATE;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_LEGGINGS;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_BOOTS;
    public static final RegistryObject<EndShardItem> ENDERIUM_SHARD;
    public static final RegistryObject<EnderiumIngotItem> ENDERIUM_INGOT;
    public static final RegistryObject<EnderiumSmithingTemplateItem> ENDERIUM_SMITHING_TEMPLATE;
    public static final RegistryObject<EnderiumSwordItem> ENDERIUM_SWORD;
    public static final RegistryObject<EnderiumPickaxeItem> ENDERIUM_PICKAXE;
    public static final RegistryObject<EnderiumAxeItem> ENDERIUM_AXE;
    public static final RegistryObject<EnderiumShovelItem> ENDERIUM_SHOVEL;
    public static final RegistryObject<EnderiumHoeItem> ENDERIUM_HOE;
    public static final RegistryObject<EndShardLocatorItem> ENDERIUM_SHARD_LOCATOR;
    public static final RegistryObject<EnderPouchItem> ENDER_POUCH;
    public static final RegistryObject<WitherSwordItem> WITHER_SWORD;
    public static final RegistryObject<RecallPotionItem> RECALL_POTION;
    public static final RegistryObject<BadOmenPotionItem> BAD_OMEN_POTION;
    public static final RegistryObject<SoulJarItem> SOUL_JAR;
    public static final RegistryObject<Potion> WITHER_POTION;
    public static final RegistryObject<Potion> WITHER_POTION_LONG;
    public static final RegistryObject<Potion> WITHER_POTION_STRONG;
    public static final RegistryObject<TreasureBagItem> UNDEAD_ARMY_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> ELDER_GUARDIAN_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> WITHER_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> ENDER_DRAGON_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> FISHING_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> PILLAGER_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> WARDEN_TREASURE_BAG;
    public static final RegistryObject<EndShardOre.EndShardOreItem> ENDERIUM_SHARD_ORE_ITEM;
    public static final RegistryObject<EnderiumBlock.EndBlockItem> ENDERIUM_BLOCK_ITEM;
    public static final RegistryObject<InfestedEndStone.InfestedEndStoneItem> INFESTED_END_STONE_ITEM;
    public static final RegistryObject<SpawnEggItem> ILLUSIONER_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> CREEPERLING_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> TANK_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> CURSED_ARMOR_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> CERBERUS_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> BLACK_WIDOW_SPAWN_EGG;
    public static final RegistryObject<EndShardOre> ENDERIUM_SHARD_ORE;
    public static final RegistryObject<EnderiumBlock> ENDERIUM_BLOCK;
    public static final RegistryObject<InfestedEndStone> INFESTED_END_STONE;
    public static final RegistryObject<BleedingEffect> BLEEDING;
    public static final RegistryObject<BleedingImmunityEffect> BLEEDING_IMMUNITY;
    public static final ResourceKey<DamageType> BLEEDING_SOURCE;
    public static final RegistryObject<SimpleParticleType> BLOOD;
    public static GameDataSaver GAME_DATA_SAVER;
    public static final GameStageTrigger GAME_STATE_TRIGGER;
    public static final TreasureBagTrigger TREASURE_BAG_TRIGGER;
    public static final BandageTrigger BANDAGE_TRIGGER;
    public static final BasicTrigger BASIC_TRIGGER;
    public static final RegistryObject<SoundEvent> UNDEAD_ARMY_APPROACHING;
    public static final RegistryObject<SoundEvent> UNDEAD_ARMY_WAVE_STARTED;
    public static final RegistryObject<LootItemFunctionType> CURSE_RANDOMLY;
    public static final RegistryObject<CreativeModeTab> PRIMARY_TAB;
    public static final RegistryObject<CreativeModeTab> TREASURE_BAGS_TAB;
    public static final AnnotationHandler ANNOTATION_HANDLER;

    static Supplier<SpawnEggItem> createEggSupplier(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor) {
        return () -> new ForgeSpawnEggItem(type, backgroundColor, highlightColor, new Item.Properties());
    }

    static RegistryObject<SoundEvent> register(String name) {
        return SOUNDS_EVENTS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)Registries.getLocation(name)));
    }

    public static UndeadArmyManager getUndeadArmyManager() {
        return GAME_DATA_SAVER != null ? GAME_DATA_SAVER.getUndeadArmyManager() : UndeadArmyManager.NOT_LOADED;
    }

    public static TreasureBagProgressManager getTreasureBagProgressManager() {
        return GAME_DATA_SAVER.getTreasureBagProgressManager();
    }

    public static ResourceLocation getLocation(String register) {
        return HELPER.getLocation(register);
    }

    public static String getLocationString(String register) {
        return HELPER.getLocationString(register);
    }

    public static ModelLayerLocation getModelLayer(String register, String layer) {
        return HELPER.getModelLayer(register, layer);
    }

    public static ModelLayerLocation getModelLayer(String register) {
        return HELPER.getModelLayer(register, "main");
    }

    public static RenderType getEyesRenderType(String register) {
        return HELPER.getEyesRenderType(register);
    }

    public static void initialize() {
        FMLJavaModLoadingContext loadingContext = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = loadingContext.getModEventBus();
        HELPER.registerAll();
        modEventBus.addListener(Registries::setup);
        modEventBus.addListener(Registries::setupClient);
        modEventBus.addListener(Registries::setupEntities);
        modEventBus.addListener(PacketHandler::registerPacket);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(Registries::onLoadingLevel);
        forgeEventBus.addListener(Registries::onSavingLevel);
        MajruszsDifficulty.SERVER_CONFIG.register(ModLoadingContext.get());
    }

    private static void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(RegistriesClient::setup);
    }

    public static void setupEntities(EntityAttributeCreationEvent event) {
        event.put((EntityType)CREEPERLING.get(), CreeperlingEntity.getAttributeMap());
        event.put((EntityType)TANK.get(), TankEntity.getAttributeMap());
        event.put((EntityType)BLACK_WIDOW.get(), BlackWidowEntity.getAttributeMap());
        event.put((EntityType)CURSED_ARMOR.get(), CursedArmorEntity.getAttributeMap());
        event.put((EntityType)CERBERUS.get(), CerberusEntity.getAttributeMap());
    }

    private static void setup(FMLCommonSetupEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CREEPERLING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)TANK.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)BLACK_WIDOW.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CURSED_ARMOR.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CERBERUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        event.enqueueWork(() -> {
            Registries.addPotionRecipe(() -> Potions.f_43599_, CERBERUS_FANG, () -> Potions.f_43600_);
            Registries.addPotionRecipe(() -> Potions.f_43602_, CERBERUS_FANG, WITHER_POTION);
            Registries.addPotionRecipe(WITHER_POTION, () -> Items.f_42451_, WITHER_POTION_LONG);
            Registries.addPotionRecipe(WITHER_POTION, () -> Items.f_42525_, WITHER_POTION_STRONG);
        });
    }

    private static void addPotionRecipe(final Supplier<? extends Potion> input, final Supplier<? extends Item> item, final Supplier<? extends Potion> output) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new IBrewingRecipe(){

            public boolean isInput(ItemStack itemStack) {
                return PotionUtils.m_43579_((ItemStack)itemStack).equals(input.get());
            }

            public boolean isIngredient(ItemStack itemStack) {
                return itemStack.m_41720_().equals(item.get());
            }

            public ItemStack getOutput(ItemStack input2, ItemStack ingredient) {
                return this.isInput(input2) && this.isIngredient(ingredient) ? PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)input2.m_41720_()), (Potion)((Potion)output.get())) : ItemStack.f_41583_;
            }
        });
    }

    public static void onLoadingLevel(LevelEvent.Load event) {
        ServerLevel overworld = Registries.getOverworld(event.getLevel());
        if (overworld == null) {
            return;
        }
        GAME_DATA_SAVER = (GameDataSaver)overworld.m_8895_().m_164861_(nbt -> new GameDataSaver(overworld, (CompoundTag)nbt), () -> new GameDataSaver(overworld), "majruszsdifficulty");
        TreasureBagManager.addTreasureBagTo(EntityType.f_20563_, (TreasureBagItem)((Object)ELDER_GUARDIAN_TREASURE_BAG.get()));
        TreasureBagManager.addTreasureBagTo(EntityType.f_20496_, (TreasureBagItem)((Object)WITHER_TREASURE_BAG.get()));
        TreasureBagManager.addTreasureBagTo(EntityType.f_20565_, (TreasureBagItem)((Object)ENDER_DRAGON_TREASURE_BAG.get()));
        TreasureBagManager.addTreasureBagTo(EntityType.f_217015_, (TreasureBagItem)((Object)WARDEN_TREASURE_BAG.get()));
    }

    public static void onSavingLevel(LevelEvent.Save event) {
        ServerLevel overworld = Registries.getOverworld(event.getLevel());
        if (overworld != null) {
            GAME_DATA_SAVER.m_77762_();
        }
    }

    @Nullable
    private static ServerLevel getOverworld(LevelAccessor levelAccessor) {
        ServerLevel overworld = levelAccessor.m_7654_() != null ? levelAccessor.m_7654_().m_129880_(Level.f_46428_) : null;
        return levelAccessor.equals(overworld) ? overworld : null;
    }

    static {
        ModConfigs.init((ConfigHandler)MajruszsDifficulty.SERVER_CONFIG, (String)Groups.DEFAULT).name("GameModifiers");
        ModConfigs.init((ConfigHandler)MajruszsDifficulty.SERVER_CONFIG, (String)Groups.UNDEAD_ARMY).name("UndeadArmy");
        ModConfigs.init((ConfigHandler)MajruszsDifficulty.SERVER_CONFIG, (String)Groups.GAME_STAGE).name("GameStage");
        ModConfigs.init((ConfigHandler)MajruszsDifficulty.SERVER_CONFIG, (String)Groups.TREASURE_BAG).name("TreasureBag");
        ModConfigs.init((ConfigHandler)MajruszsDifficulty.SERVER_CONFIG, (String)Groups.MOBS).name("Mobs");
        BLOCKS = HELPER.create(ForgeRegistries.Keys.BLOCKS);
        ITEMS = HELPER.create(ForgeRegistries.Keys.ITEMS);
        ENTITY_TYPES = HELPER.create(ForgeRegistries.Keys.ENTITY_TYPES);
        MOB_EFFECTS = HELPER.create(ForgeRegistries.Keys.MOB_EFFECTS);
        PARTICLE_TYPES = HELPER.create(ForgeRegistries.Keys.PARTICLE_TYPES);
        SOUNDS_EVENTS = HELPER.create(ForgeRegistries.Keys.SOUND_EVENTS);
        LOOT_FUNCTIONS = HELPER.create(net.minecraft.core.registries.Registries.f_257015_);
        POTIONS = HELPER.create(ForgeRegistries.Keys.POTIONS);
        CREATIVE_MODE_TABS = HELPER.create(net.minecraft.core.registries.Registries.f_279569_);
        CREEPERLING = ENTITY_TYPES.register("creeperling", CreeperlingEntity.createSupplier());
        TANK = ENTITY_TYPES.register("tank", TankEntity.createSupplier());
        CURSED_ARMOR = ENTITY_TYPES.register("cursed_armor", CursedArmorEntity.createSupplier());
        CERBERUS = ENTITY_TYPES.register("cerberus", CerberusEntity.createSupplier());
        BLACK_WIDOW = ENTITY_TYPES.register("black_widow", BlackWidowEntity.createSupplier());
        BANDAGE = ITEMS.register("bandage", BandageItem::new);
        GOLDEN_BANDAGE = ITEMS.register("golden_bandage", GoldenBandageItem::new);
        CLOTH = ITEMS.register("cloth", ClothItem::new);
        BATTLE_STANDARD = ITEMS.register("undead_battle_standard", UndeadBattleStandardItem::new);
        TATTERED_HELMET = ITEMS.register("tattered_helmet", TatteredArmorItem.Helmet::new);
        TATTERED_CHESTPLATE = ITEMS.register("tattered_chestplate", TatteredArmorItem.Chestplate::new);
        TATTERED_LEGGINGS = ITEMS.register("tattered_leggings", TatteredArmorItem.Leggings::new);
        TATTERED_BOOTS = ITEMS.register("tattered_boots", TatteredArmorItem.Boots::new);
        CERBERUS_FANG = ITEMS.register("cerberus_fang", CerberusFangItem::new);
        ENDERIUM_HELMET = ITEMS.register("enderium_helmet", EnderiumArmorItem.Helmet::new);
        ENDERIUM_CHESTPLATE = ITEMS.register("enderium_chestplate", EnderiumArmorItem.Chestplate::new);
        ENDERIUM_LEGGINGS = ITEMS.register("enderium_leggings", EnderiumArmorItem.Leggings::new);
        ENDERIUM_BOOTS = ITEMS.register("enderium_boots", EnderiumArmorItem.Boots::new);
        ENDERIUM_SHARD = ITEMS.register("enderium_shard", EndShardItem::new);
        ENDERIUM_INGOT = ITEMS.register("enderium_ingot", EnderiumIngotItem::new);
        ENDERIUM_SMITHING_TEMPLATE = ITEMS.register("enderium_upgrade_smithing_template", EnderiumSmithingTemplateItem::new);
        ENDERIUM_SWORD = ITEMS.register("enderium_sword", EnderiumSwordItem::new);
        ENDERIUM_PICKAXE = ITEMS.register("enderium_pickaxe", EnderiumPickaxeItem::new);
        ENDERIUM_AXE = ITEMS.register("enderium_axe", EnderiumAxeItem::new);
        ENDERIUM_SHOVEL = ITEMS.register("enderium_shovel", EnderiumShovelItem::new);
        ENDERIUM_HOE = ITEMS.register("enderium_hoe", EnderiumHoeItem::new);
        ENDERIUM_SHARD_LOCATOR = ITEMS.register("enderium_shard_locator", EndShardLocatorItem::new);
        ENDER_POUCH = ITEMS.register("ender_pouch", EnderPouchItem::new);
        WITHER_SWORD = ITEMS.register("wither_sword", WitherSwordItem::new);
        RECALL_POTION = ITEMS.register("recall_potion", RecallPotionItem::new);
        BAD_OMEN_POTION = ITEMS.register("bad_omen_potion", BadOmenPotionItem::new);
        SOUL_JAR = ITEMS.register("soul_jar", SoulJarItem::new);
        WITHER_POTION = POTIONS.register("wither", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, Utility.secondsToTicks((double)40.0))}));
        WITHER_POTION_LONG = POTIONS.register("long_wither", () -> new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, Utility.secondsToTicks((double)80.0))}));
        WITHER_POTION_STRONG = POTIONS.register("strong_wither", () -> new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, Utility.secondsToTicks((double)20.0), 1)}));
        UNDEAD_ARMY_TREASURE_BAG = ITEMS.register("undead_army_treasure_bag", TreasureBagItem.UndeadArmy::new);
        ELDER_GUARDIAN_TREASURE_BAG = ITEMS.register("elder_guardian_treasure_bag", TreasureBagItem.ElderGuardian::new);
        WITHER_TREASURE_BAG = ITEMS.register("wither_treasure_bag", TreasureBagItem.Wither::new);
        ENDER_DRAGON_TREASURE_BAG = ITEMS.register("ender_dragon_treasure_bag", TreasureBagItem.EnderDragon::new);
        FISHING_TREASURE_BAG = ITEMS.register("fishing_treasure_bag", TreasureBagItem.Fishing::new);
        PILLAGER_TREASURE_BAG = ITEMS.register("pillager_treasure_bag", TreasureBagItem.Pillager::new);
        WARDEN_TREASURE_BAG = ITEMS.register("warden_treasure_bag", TreasureBagItem.Warden::new);
        ENDERIUM_SHARD_ORE_ITEM = ITEMS.register("enderium_shard_ore", EndShardOre.EndShardOreItem::new);
        ENDERIUM_BLOCK_ITEM = ITEMS.register("enderium_block", EnderiumBlock.EndBlockItem::new);
        INFESTED_END_STONE_ITEM = ITEMS.register("infested_end_stone", InfestedEndStone.InfestedEndStoneItem::new);
        ILLUSIONER_SPAWN_EGG = ITEMS.register("illusioner_spawn_egg", Registries.createEggSupplier(() -> EntityType.f_20459_, 1268375, 0x959B9B));
        CREEPERLING_SPAWN_EGG = ITEMS.register("creeperling_spawn_egg", Registries.createEggSupplier(CREEPERLING, 894731, 0));
        TANK_SPAWN_EGG = ITEMS.register("tank_spawn_egg", Registries.createEggSupplier(TANK, 0xC1C1C1, 0x949494));
        CURSED_ARMOR_SPAWN_EGG = ITEMS.register("cursed_armor_spawn_egg", Registries.createEggSupplier(CURSED_ARMOR, 0x808080, 0xE1E1E1));
        CERBERUS_SPAWN_EGG = ITEMS.register("cerberus_spawn_egg", Registries.createEggSupplier(CERBERUS, 0x212121, 0xE0E0E0));
        BLACK_WIDOW_SPAWN_EGG = ITEMS.register("black_widow_spawn_egg", Registries.createEggSupplier(BLACK_WIDOW, 0x212121, 0xE12121));
        Stream.of("normal", "expert", "master", "bleeding").forEach(name -> ITEMS.register("advancement_" + name, FakeItem::new));
        ENDERIUM_SHARD_ORE = BLOCKS.register("enderium_shard_ore", EndShardOre::new);
        ENDERIUM_BLOCK = BLOCKS.register("enderium_block", EnderiumBlock::new);
        INFESTED_END_STONE = BLOCKS.register("infested_end_stone", InfestedEndStone::new);
        BLEEDING = MOB_EFFECTS.register("bleeding", BleedingEffect::new);
        BLEEDING_IMMUNITY = MOB_EFFECTS.register("bleeding_immunity", BleedingImmunityEffect::new);
        BLEEDING_SOURCE = ResourceKey.m_135785_((ResourceKey)net.minecraft.core.registries.Registries.f_268580_, (ResourceLocation)Registries.getLocation("bleeding"));
        BLOOD = PARTICLE_TYPES.register("blood_particle", () -> new SimpleParticleType(true));
        GAME_STATE_TRIGGER = (GameStageTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new GameStageTrigger());
        TREASURE_BAG_TRIGGER = (TreasureBagTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new TreasureBagTrigger());
        BANDAGE_TRIGGER = (BandageTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new BandageTrigger());
        BASIC_TRIGGER = HELPER.registerBasicTrigger();
        UNDEAD_ARMY_APPROACHING = Registries.register("undead_army.approaching");
        UNDEAD_ARMY_WAVE_STARTED = Registries.register("undead_army.wave_started");
        CURSE_RANDOMLY = LOOT_FUNCTIONS.register("curse_randomly", CurseRandomlyFunction::newType);
        PRIMARY_TAB = CREATIVE_MODE_TABS.register("primary", CreativeModeTabs.primary());
        TREASURE_BAGS_TAB = CREATIVE_MODE_TABS.register("treasure_bags", CreativeModeTabs.treasureBags());
        ANNOTATION_HANDLER = new AnnotationHandler("majruszsdifficulty");
    }

    public static class Groups {
        public static final String DEFAULT = Registries.getLocationString("default");
        public static final String UNDEAD_ARMY = Registries.getLocationString("undead_army");
        public static final String GAME_STAGE = Registries.getLocationString("game_stage");
        public static final String TREASURE_BAG = Registries.getLocationString("treasure_bag");
        public static final String MOBS = Registries.getLocationString("mobs");
    }
}

