/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects;

import com.majruszsdifficulty.PacketHandler;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.configs.BleedingConfig;
import com.majruszsdifficulty.gamemodifiers.contexts.OnBleedingCheck;
import com.majruszsdifficulty.gui.BleedingGui;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import com.mlib.data.SerializableStructure;
import com.mlib.effects.ParticleHandler;
import com.mlib.entities.EntityHelper;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnDamaged;
import com.mlib.gamemodifiers.contexts.OnDeath;
import com.mlib.gamemodifiers.contexts.OnEffectApplicable;
import com.mlib.gamemodifiers.contexts.OnEntityTick;
import com.mlib.gamemodifiers.contexts.OnItemAttributeTooltip;
import com.mlib.mobeffects.MobEffectHelper;
import com.mlib.text.TextHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class BleedingEffect
extends MobEffect {
    static Supplier<Boolean> IS_ENABLED = () -> true;
    static Supplier<Integer> GET_AMPLIFIER = () -> 0;
    static Function<EquipmentSlot, Float> GET_ARMOR_MULTIPLIER = slot -> Float.valueOf(1.0f);

    public static boolean isEnabled() {
        return IS_ENABLED.get();
    }

    public static int getAmplifier() {
        return GET_AMPLIFIER.get();
    }

    public BleedingEffect() {
        super(MobEffectCategory.HARMFUL, -2271915);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
    }

    public boolean m_6584_(int duration, int amplifier) {
        return false;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public static class BloodMessage
    extends SerializableStructure {
        int entityId;

        public BloodMessage() {
            this.define(null, () -> this.entityId, x -> {
                this.entityId = x;
            });
        }

        public BloodMessage(Entity entity) {
            this();
            this.entityId = entity.m_19879_();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onClient(NetworkEvent.Context context) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && minecraft.f_91073_.m_6815_(this.entityId) == minecraft.f_91074_) {
                BleedingGui.addBloodOnScreen(3);
            }
        }
    }

    @AutoInstance
    public static class Bleeding {
        static final ParticleHandler PARTICLES = new ParticleHandler(Registries.BLOOD, () -> new Vec3(0.2, 0.5, 0.2), ParticleHandler.speed((float)0.075f));
        static final String ATTRIBUTE_ID = "effect.majruszsdifficulty.bleeding.armor_tooltip";
        static final int BLOOD_TICK_COOLDOWN = Utility.secondsToTicks((double)4.0);
        final StringListConfig immuneMobs = new StringListConfig(new String[]{"minecraft:skeleton_horse", "minecraft:zombie_horse"});
        final BleedingConfig effect = new BleedingConfig();
        final HashMap<Integer, Integer> entityTicks = new HashMap();

        public Bleeding() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("Bleeding").comment("Common config for all Bleeding effects.");
            OnEntityTick.listen(this::spawnParticles).addCondition(Condition.isServer()).addCondition(Condition.cooldown((int)3, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addCondition(Condition.hasEffect(Registries.BLEEDING, data -> data.entity)).insertTo(group);
            OnEntityTick.listen(this::tick).addCondition(Condition.isServer()).addCondition(Condition.hasEffect(Registries.BLEEDING, data -> data.entity)).insertTo(group);
            OnDeath.listen(this::spawnParticles).addCondition(Condition.isServer()).addCondition(Condition.hasEffect(Registries.BLEEDING, data -> data.target)).insertTo(group);
            OnEffectApplicable.listen(this::cancelEffect).addCondition(Condition.predicate(data -> !BleedingEffect.isEnabled())).addCondition(Condition.predicate(data -> data.effect.equals(Registries.BLEEDING_IMMUNITY.get()))).insertTo(group);
            Condition excludable = Condition.excludable();
            IS_ENABLED = () -> ((BooleanConfig)excludable.getConfigs().get(0)).isEnabled();
            Condition armorChance = Condition.armorDependentChance((double)0.8, (double)0.6, (double)0.7, (double)0.9, data -> data.target);
            GET_ARMOR_MULTIPLIER = slot -> Float.valueOf(((DoubleConfig)((ConfigGroup)armorChance.getConfigs().get(0)).getConfigs().get(3 - slot.m_20749_())).asFloat());
            OnDamaged.listen(this::applyBleeding).addCondition(Condition.isServer()).addCondition(excludable).addCondition(armorChance).addCondition(Condition.predicate(this::isNotImmune)).addCondition(OnDamaged.dealtAnyDamage()).addConfig((IConfigurable)this.immuneMobs.name("immune_mobs").comment("Specifies which mobs should not be affected by Bleeding (all undead mobs are immune by default).")).addConfig((IConfigurable)this.effect).insertTo(group);
            OnItemAttributeTooltip.listen(this::addChanceTooltip).addCondition(Condition.predicate(data -> data.item instanceof ArmorItem)).addCondition(Condition.predicate(data -> BleedingEffect.isEnabled())).insertTo(group);
            GET_AMPLIFIER = this.effect::getAmplifier;
        }

        private void spawnParticles(OnEntityTick.Data data) {
            int amplifier = MobEffectHelper.getAmplifier((LivingEntity)data.entity, (MobEffect)((MobEffect)Registries.BLEEDING.get()));
            float walkDistanceDelta = EntityHelper.getWalkDistanceDelta((LivingEntity)data.entity);
            this.spawnParticles(data.getServerLevel(), (Entity)data.entity, Random.roundRandomly((double)(1.0 + (15.0 + (double)amplifier) * (double)walkDistanceDelta)));
        }

        private void tick(OnEntityTick.Data data) {
            LivingEntity entity = data.entity;
            int amplifier = MobEffectHelper.getAmplifier((LivingEntity)entity, (MobEffect)((MobEffect)Registries.BLEEDING.get()));
            int extraDuration = Random.roundRandomly((double)(0.3 * (double)(amplifier + 2) * (7.26 * (double)EntityHelper.getWalkDistanceDelta((LivingEntity)entity) + 1.0)));
            int duration = this.entityTicks.getOrDefault(entity.m_19879_(), 0) + extraDuration;
            if (duration >= BLOOD_TICK_COOLDOWN) {
                this.dealDamage(entity);
                duration = 0;
            }
            this.entityTicks.put(entity.m_19879_(), duration);
        }

        private void dealDamage(LivingEntity entity) {
            Holder.Reference damageType = entity.m_9236_().m_9598_().m_175515_(net.minecraft.core.registries.Registries.f_268580_).m_246971_(Registries.BLEEDING_SOURCE);
            net.minecraft.world.effect.MobEffectInstance mobEffectInstance = entity.m_21124_((MobEffect)Registries.BLEEDING.get());
            if (mobEffectInstance instanceof MobEffectInstance) {
                MobEffectInstance effectInstance = (MobEffectInstance)mobEffectInstance;
                Vec3 motion = entity.m_20184_();
                entity.m_6469_((DamageSource)new EntityBleedingDamageSource((Holder<DamageType>)damageType, effectInstance.damageSourceEntity), 1.0f);
                entity.m_20256_(motion);
            } else {
                entity.m_6469_(new DamageSource((Holder)damageType), 1.0f);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new BloodMessage((Entity)player));
            }
            this.entityTicks.put(entity.m_19879_(), 0);
        }

        private void spawnParticles(OnDeath.Data data) {
            this.spawnParticles(data.getServerLevel(), (Entity)data.target, 100);
        }

        private void spawnParticles(ServerLevel level, Entity entity, int amountOfParticles) {
            Vec3 position = new Vec3(entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_());
            PARTICLES.spawn(level, position, amountOfParticles);
        }

        private void cancelEffect(OnEffectApplicable.Data data) {
            data.event.setResult(Event.Result.DENY);
        }

        private void applyBleeding(OnDamaged.Data data) {
            OnBleedingCheck.Data bleedingData = OnBleedingCheck.dispatch(data.event);
            if (bleedingData.isEffectTriggered() && this.effect.apply(data)) {
                this.dealDamage(data.target);
            }
        }

        private boolean isNotImmune(OnDamaged.Data data) {
            return !this.immuneMobs.contains(Utility.getRegistryString((LivingEntity)data.target));
        }

        private void addChanceTooltip(OnItemAttributeTooltip.Data data) {
            for (EquipmentSlot slot : EquipmentSlots.ARMOR) {
                if (!data.itemStack.m_41638_(slot).containsKey((Object)Attributes.f_22284_)) continue;
                String multiplier = TextHelper.minPrecision((float)GET_ARMOR_MULTIPLIER.apply(slot).floatValue());
                data.add(slot, (Component)Component.m_237110_((String)ATTRIBUTE_ID, (Object[])new Object[]{multiplier}).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public static class MobEffectInstance
    extends net.minecraft.world.effect.MobEffectInstance {
        @Nullable
        protected final Entity damageSourceEntity;

        public MobEffectInstance(int duration, int amplifier, boolean ambient, @Nullable LivingEntity attacker) {
            super((MobEffect)Registries.BLEEDING.get(), duration, amplifier, ambient, false, true);
            this.damageSourceEntity = attacker;
        }
    }

    public static class TagsProvider
    extends net.minecraft.data.tags.TagsProvider<DamageType> {
        public TagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
            super(output, net.minecraft.core.registries.Registries.f_268580_, registries, "majruszsdifficulty", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(DamageTypeTags.f_268490_).m_255204_(Registries.BLEEDING_SOURCE);
        }
    }

    public static class EntityBleedingDamageSource
    extends DamageSource {
        @Nullable
        protected final Entity damageSourceEntity;

        public EntityBleedingDamageSource(Holder<DamageType> damageType, @Nullable Entity damageSourceEntity) {
            super(damageType);
            this.damageSourceEntity = damageSourceEntity;
        }

        @Nullable
        public Entity m_7640_() {
            return null;
        }

        @Nullable
        public Entity m_7639_() {
            return this.damageSourceEntity;
        }
    }
}

