/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entities;

import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.effects.SoundHandler;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnEntityTick;
import com.mlib.gamemodifiers.contexts.OnItemTooltip;
import com.mlib.math.Range;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class BlackWidowEntity
extends Spider {
    public static Supplier<EntityType<BlackWidowEntity>> createSupplier() {
        return () -> EntityType.Builder.m_20704_(BlackWidowEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.7f, 0.35f).m_20712_("black_widow");
    }

    public static AttributeSupplier getAttributeMap() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22265_();
    }

    public BlackWidowEntity(EntityType<? extends BlackWidowEntity> type, Level world) {
        super(type, world);
    }

    public int m_213860_() {
        return Random.nextInt((int)3);
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (this.m_20067_()) {
            return;
        }
        float randomizedVolume = ((Float)SoundHandler.randomized((float)(volume * 0.6f)).get()).floatValue();
        float randomizedPitch = ((Float)SoundHandler.randomized((float)(pitch * 1.4f)).get()).floatValue();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_5720_(), randomizedVolume, randomizedPitch);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.2f;
    }

    @Deprecated
    @AutoInstance
    public static class TempTooltip {
        public TempTooltip() {
            OnItemTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> data.itemStack.m_41720_().equals(Registries.BLACK_WIDOW_SPAWN_EGG.get())));
        }

        private void addTooltip(OnItemTooltip.Data data) {
            data.tooltip.add(Component.m_237113_((String)"This mob is not finished yet, coming soon in the next major update!").m_130940_(ChatFormatting.RED));
        }
    }

    @AutoInstance
    public static class WebAbility {
        final DoubleConfig delay = new DoubleConfig(30.0, new Range((Number)5.0, (Number)600.0));

        public WebAbility() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("BlackWidowWebAbility").comment("Black Widow spawns the web when in combat.");
            OnEntityTick.listen(this::spawnWeb).addCondition(Condition.isServer()).addCondition(Condition.excludable()).addCondition(Condition.predicate(data -> data.entity instanceof BlackWidowEntity)).addCondition(Condition.predicate(this::ticksHavePassed)).addConfig((IConfigurable)this.delay.name("delay").comment("Duration between creating a new web (in seconds).")).insertTo(group);
        }

        private void spawnWeb(OnEntityTick.Data data) {
            data.getServerLevel().m_7731_(data.entity.m_20183_(), Blocks.f_50033_.m_49966_(), 3);
        }

        private boolean ticksHavePassed(OnEntityTick.Data data) {
            return data.entity.f_19797_ % this.delay.asTicks() == 0;
        }
    }
}

