/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entities;

import com.majruszsdifficulty.Registries;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.ConfigGroup;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnExplosionDetonate;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public class CreeperlingEntity
extends Creeper {
    public static Supplier<EntityType<CreeperlingEntity>> createSupplier() {
        return () -> EntityType.Builder.m_20704_(CreeperlingEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 0.9f).m_20712_("creeperling");
    }

    public static AttributeSupplier getAttributeMap() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.35).m_22265_();
    }

    public CreeperlingEntity(EntityType<? extends CreeperlingEntity> type, Level level) {
        super(type, level);
        this.f_32272_ = 2;
        this.f_21364_ = 3;
    }

    public boolean m_7090_() {
        return false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.75f;
    }

    @AutoInstance
    public static class WeakExplosions {
        public WeakExplosions() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("CreeperlingWeakExplosion").comment("Makes Creeperling explosions not destroy blocks and items.");
            OnExplosionDetonate.listen(this::weakenExplosion).addCondition(Condition.excludable()).addCondition(Condition.predicate(data -> data.explosion.getExploder() instanceof CreeperlingEntity)).insertTo(group);
        }

        private void weakenExplosion(OnExplosionDetonate.Data data) {
            data.explosion.m_46080_();
            data.event.getAffectedEntities().removeIf(entity -> !(entity instanceof LivingEntity));
        }
    }
}

