/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.Priority;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public class CustomConditions {
    public static <DataType> Condition<DataType> gameStage(GameStage ... defaultGameStages) {
        StringListConfig gameStages = new StringListConfig((String[])Stream.of(defaultGameStages).map(Enum::name).toArray(String[]::new));
        return new Condition(data -> gameStages.contains(GameStage.getCurrentStage().name())).priority(Priority.HIGH).configurable(true).addConfig((IConfigurable)gameStages.name("game_stages").comment("Determines during which game stages it can happen."));
    }

    public static <DataType> Condition<DataType> gameStageAtLeast(GameStage defaultGameStage) {
        return CustomConditions.gameStage((GameStage[])Stream.of(GameStage.values()).filter(gameStage -> gameStage.ordinal() >= defaultGameStage.ordinal()).toArray(GameStage[]::new));
    }

    public static <DataType> Condition<DataType> isNotPartOfGroup(Function<DataType, Entity> entity) {
        Predicate<Object> predicate = data -> {
            PathfinderMob mob;
            Object patt1644$temp = entity.apply(data);
            return patt1644$temp instanceof PathfinderMob && !(mob = (PathfinderMob)patt1644$temp).getPersistentData().m_128471_("MajruszsDifficultySidekick") && !mob.getPersistentData().m_128471_("MajruszsDifficultyLeader");
        };
        return new Condition(predicate).priority(Priority.HIGH);
    }

    public static <DataType> Condition<DataType> isNotPartOfUndeadArmy(Function<DataType, Entity> entity) {
        return new Condition(data -> !Registries.getUndeadArmyManager().isPartOfUndeadArmy((Entity)entity.apply(data)));
    }

    public static <DataType> Condition<DataType> isNotNearUndeadArmy(Function<DataType, Entity> entity) {
        return new Condition(data -> Registries.getUndeadArmyManager().findNearestUndeadArmy(((Entity)entity.apply(data)).m_20183_()) == null);
    }
}

