/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.configs;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.gamemodifiers.configs.ProgressiveEffectConfig;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.gamemodifiers.contexts.OnDamaged;
import com.mlib.mobeffects.MobEffectHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class BleedingConfig
extends ProgressiveEffectConfig {
    public BleedingConfig(GameStage.Double duration) {
        super(Registries.BLEEDING, new GameStage.Integer(0, 1, 2), duration);
    }

    public BleedingConfig(double duration) {
        this(new GameStage.Double(duration, duration, duration));
    }

    public BleedingConfig() {
        this(24.0);
    }

    public boolean apply(OnDamaged.Data data) {
        LivingEntity target = data.target;
        LivingEntity attacker = data.attacker;
        BleedingEffect.MobEffectInstance effectInstance = new BleedingEffect.MobEffectInstance(this.getDuration(), this.getAmplifier(), false, attacker);
        if (!MobEffectHelper.tryToApply((LivingEntity)target, (MobEffectInstance)effectInstance)) {
            return false;
        }
        if (target instanceof ServerPlayer) {
            ServerPlayer targetPlayer = (ServerPlayer)target;
            Registries.BASIC_TRIGGER.trigger(targetPlayer, "bleeding_received");
            if (data.source.m_276093_(DamageTypes.f_268585_)) {
                Registries.BASIC_TRIGGER.trigger(targetPlayer, "cactus_bleeding");
            }
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer attackerPlayer = (ServerPlayer)attacker;
            Registries.BASIC_TRIGGER.trigger(attackerPlayer, "bleeding_inflicted");
        }
        return true;
    }
}

