/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.ConfigGroup;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnSpawned;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;

@AutoInstance
public class CreeperSpawnCharged {
    public CreeperSpawnCharged() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("CreeperSpawnCharged").comment("Creeper may spawn charged.");
        OnSpawned.listenSafe(this::chargeCreeper).addCondition(CustomConditions.gameStageAtLeast(GameStage.NORMAL)).addCondition(Condition.chanceCRD((double)0.125, (boolean)true)).addCondition(Condition.isServer()).addCondition(Condition.excludable()).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(Condition.predicate(data -> data.target instanceof Creeper)).insertTo(group);
    }

    private void chargeCreeper(OnSpawned.Data data) {
        Creeper creeper = (Creeper)data.target;
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)data.getServerLevel());
        if (lightningBolt != null) {
            creeper.m_8038_(data.getServerLevel(), lightningBolt);
            creeper.m_20095_();
        }
    }
}

