/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.Utility;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import com.mlib.effects.ParticleHandler;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnLoot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

@Deprecated(forRemoval=true)
@AutoInstance
public class DoubleLoot {
    static final ParticleHandler AWARD = new ParticleHandler(ParticleTypes.f_123748_, () -> new Vec3(0.5, 1.0, 0.5), () -> Float.valueOf(0.1f));
    final StringListConfig forbiddenItems = new StringListConfig(new String[]{"minecraft:nether_star", "minecraft:totem_of_undying"});

    public DoubleLoot() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("DoubleLoot").comment("Gives a chance to double the loot.").addConfig((IConfigurable)this.forbiddenItems.name("forbidden_items").comment("List of items that cannot be duplicated."));
        OnDoubleLoot.listen(this::doubleLoot, 0.0, GameStage.NORMAL).name("NormalMode").comment("Determines the chance on Normal Mode.").insertTo(group);
        OnDoubleLoot.listen(this::doubleLoot, 0.2, GameStage.EXPERT).name("ExpertMode").comment("Determines the chance on Expert Mode.").insertTo(group);
        OnDoubleLoot.listen(this::doubleLoot, 0.4, GameStage.MASTER).name("MasterMode").comment("Determines the chance on Master Mode.").insertTo(group);
    }

    private void doubleLoot(OnLoot.Data data) {
        assert (data.entity != null && data.lastDamagePlayer != null);
        boolean doubledAtLeastOneItem = this.replaceLoot((List<ItemStack>)data.generatedLoot);
        if (doubledAtLeastOneItem && data.getServerLevel() != null) {
            AWARD.spawn(data.getServerLevel(), data.entity.m_20182_().m_82520_(0.0, 0.5, 0.0), 12);
        }
    }

    private boolean replaceLoot(List<ItemStack> generatedLoot) {
        boolean doubledAtLeastOneItem = false;
        ArrayList<ItemStack> doubledLoot = new ArrayList<ItemStack>();
        for (ItemStack itemStack : generatedLoot) {
            doubledLoot.add(itemStack);
            if (!this.isAllowed(itemStack)) continue;
            doubledLoot.add(itemStack);
            doubledAtLeastOneItem = true;
        }
        generatedLoot.clear();
        generatedLoot.addAll(doubledLoot);
        return doubledAtLeastOneItem;
    }

    private boolean isAllowed(ItemStack itemStack) {
        return !itemStack.m_41619_() && !this.forbiddenItems.contains(Utility.getRegistryString((ItemStack)itemStack));
    }

    private static class OnDoubleLoot {
        private OnDoubleLoot() {
        }

        public static Context<OnLoot.Data> listen(Consumer<OnLoot.Data> consumer, double chance, GameStage stage) {
            return OnLoot.listen(consumer).addCondition(CustomConditions.gameStage(stage)).addCondition(Condition.chanceCRD((double)chance, (boolean)false)).addCondition(OnLoot.hasLastDamagePlayer()).addCondition(OnLoot.hasEntity());
        }
    }
}

