/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.ConfigGroup;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnDamaged;
import com.mlib.levels.LevelHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;

@AutoInstance
public class EndermanTeleportAttack {
    public EndermanTeleportAttack() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("EndermanTeleport").comment("Enderman attack may teleport the player somewhere nearby.");
        OnDamaged.listen(this::teleportPlayerRandomly).addCondition(CustomConditions.gameStageAtLeast(GameStage.MASTER)).addCondition(Condition.isServer()).addCondition(Condition.chanceCRD((double)0.5, (boolean)true)).addCondition(Condition.excludable()).addCondition(Condition.predicate(data -> data.attacker instanceof EnderMan)).addCondition(Condition.predicate(data -> data.source.m_7640_() == data.attacker)).insertTo(group);
    }

    private void teleportPlayerRandomly(OnDamaged.Data data) {
        LivingEntity target = data.target;
        if (LevelHelper.teleportNearby((LivingEntity)target, (ServerLevel)data.getServerLevel(), (double)10.0) && target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            Registries.BASIC_TRIGGER.trigger(player, "enderman_teleport_attack");
        }
    }
}

