/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamemodifiers.contexts.OnBleedingCheck;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnItemAttributeTooltip;
import com.mlib.items.ItemHelper;
import com.mlib.text.TextHelper;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;

@AutoInstance
public class SharpToolsBleeding {
    static final String ATTRIBUTE_ID = "effect.majruszsdifficulty.bleeding.item_tooltip";
    static Supplier<Boolean> IS_ENABLED = () -> false;
    static Supplier<Float> GET_CHANCE = () -> Float.valueOf(0.0f);

    public SharpToolsBleeding() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("SharpToolsBleeding").comment("All sharp items (tools, shears etc.) may inflict bleeding.");
        Condition chance = Condition.chanceCRD((double)0.25, (boolean)false);
        GET_CHANCE = () -> Float.valueOf(((DoubleConfig)chance.getConfigs().get(0)).asFloat());
        Condition excludable = Condition.excludable();
        IS_ENABLED = () -> ((BooleanConfig)excludable.getConfigs().get(0)).isEnabled() && BleedingEffect.isEnabled();
        OnBleedingCheck.listen(OnBleedingCheck.Data::trigger).addCondition(CustomConditions.gameStageAtLeast(GameStage.NORMAL)).addCondition(chance).addCondition(excludable).addCondition(Condition.isLivingBeing(data -> data.target)).addCondition(Condition.predicate(data -> ItemHelper.hasInMainHand((LivingEntity)data.attacker, (Class[])new Class[]{TieredItem.class, TridentItem.class, ShearsItem.class}))).addCondition(Condition.predicate(data -> data.source.m_7640_() == data.attacker)).insertTo(group);
        OnItemAttributeTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> data.item instanceof TieredItem || data.item instanceof TridentItem || data.item instanceof ShearsItem)).addCondition(Condition.predicate(IS_ENABLED)).insertTo(group);
    }

    private void addTooltip(OnItemAttributeTooltip.Data data) {
        String chance = TextHelper.percent((float)GET_CHANCE.get().floatValue());
        String amplifier = TextHelper.toRoman((int)(BleedingEffect.getAmplifier() + 1));
        data.add(EquipmentSlot.MAINHAND, (Component)Component.m_237110_((String)ATTRIBUTE_ID, (Object[])new Object[]{chance, amplifier}).m_130940_(ChatFormatting.DARK_GREEN));
    }
}

