/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamestage.handlers;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.contexts.OnGameStageChange;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.annotations.AutoInstance;
import com.mlib.data.JsonListener;
import com.mlib.data.SerializableStructure;
import com.mlib.gamemodifiers.Condition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

@AutoInstance
public class ChatMessageSender {
    final Supplier<Messages> messages = JsonListener.add((String)"game_stages", (ResourceLocation)Registries.getLocation("messages"), Messages.class, Messages::new);

    public ChatMessageSender() {
        OnGameStageChange.listen(this::sendMessage).addCondition(Condition.predicate(data -> !data.isLoadedFromDisk())).addCondition(Condition.predicate(data -> data.previous.ordinal() < data.current.ordinal()));
    }

    private void sendMessage(OnGameStageChange.Data data) {
        this.messages.get().stream().filter(message -> data.current == message.gameStage).forEach(message -> {
            ChatFormatting[] chatFormattingArray;
            MutableComponent mutableComponent = Component.m_237115_((String)message.id);
            if (message.chatFormatting != null) {
                ChatFormatting[] chatFormattingArray2 = new ChatFormatting[1];
                chatFormattingArray = chatFormattingArray2;
                chatFormattingArray2[0] = message.chatFormatting;
            } else {
                chatFormattingArray = data.current.getChatFormatting();
            }
            MutableComponent component = mutableComponent.m_130944_(chatFormattingArray);
            data.server.m_6846_().m_11314_().forEach(player -> player.m_5661_((Component)component, false));
        });
    }

    static class Messages
    extends SerializableStructure {
        List<Message> messages = new ArrayList<Message>();

        public Messages() {
            this.define(null, () -> this.messages, x -> {
                this.messages = x;
            }, Message::new);
        }

        public Stream<Message> stream() {
            return this.messages.stream();
        }
    }

    static class Message
    extends SerializableStructure {
        String id = "";
        GameStage gameStage = GameStage.NORMAL;
        ChatFormatting chatFormatting = null;

        public Message() {
            this.define("id", () -> this.id, x -> {
                this.id = x;
            });
            this.define("game_stage", () -> this.gameStage, x -> {
                this.gameStage = x;
            }, GameStage::values);
            this.define("style", () -> this.chatFormatting, x -> {
                this.chatFormatting = x;
            }, ChatFormatting::values);
        }
    }
}

