/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.items.GoldenBandageItem;
import com.mlib.Utility;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.ConfigGroup;
import com.mlib.config.EffectConfig;
import com.mlib.config.IConfigurable;
import com.mlib.effects.SoundHandler;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnPlayerInteract;
import com.mlib.items.ItemHelper;
import com.mlib.text.TextHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BandageItem
extends Item {
    static final String TOOLTIP_ID = "item.majruszsdifficulty.bandage.effect";

    public BandageItem(Rarity rarity) {
        super(new Item.Properties().m_41487_(16).m_41497_(rarity));
    }

    public BandageItem() {
        this(Rarity.COMMON);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (this instanceof GoldenBandageItem) {
            components.add((Component)this.buildComponent(Effects.INSTANCE.goldenRegeneration).m_130940_(ChatFormatting.BLUE));
            components.add((Component)this.buildComponent(Effects.INSTANCE.goldenImmunity).m_130940_(ChatFormatting.BLUE));
        } else {
            components.add((Component)this.buildComponent(Effects.INSTANCE.regeneration).m_130940_(ChatFormatting.BLUE));
        }
        components.add(CommonComponents.f_237098_);
        components.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
        components.add((Component)Component.m_237115_((String)TOOLTIP_ID).m_130940_(ChatFormatting.BLUE));
    }

    private MutableComponent buildComponent(EffectConfig config) {
        Component effectName = config.getEffect().m_19482_();
        MutableComponent fullName = config.getAmplifier() > 0 ? Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectName.getString(), TextHelper.toRoman((int)(config.getAmplifier() + 1))}) : Component.m_237113_((String)effectName.getString());
        return Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{fullName.getString(), StringUtil.m_14404_((int)config.getDuration())});
    }

    @AutoInstance
    public static class Effects {
        static Effects INSTANCE = null;
        final ConfigGroup bandageGroup = new ConfigGroup(new IConfigurable[0]);
        final EffectConfig regeneration = new EffectConfig(MobEffects.f_19605_, 0, 4.0);
        final ConfigGroup goldenBandageGroup = new ConfigGroup(new IConfigurable[0]);
        final EffectConfig goldenRegeneration = new EffectConfig(MobEffects.f_19605_, 1, 4.0);
        final EffectConfig goldenImmunity = new EffectConfig(Registries.BLEEDING_IMMUNITY, 0, 60.0);

        public Effects() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("Bandages");
            INSTANCE = this;
            this.bandageGroup.addConfig((IConfigurable)this.regeneration.name("Regeneration"));
            this.goldenBandageGroup.addConfig((IConfigurable)this.goldenRegeneration.name("Regeneration")).addConfig((IConfigurable)this.goldenImmunity.name("Immunity"));
            OnPlayerInteract.listen(this::useBandage).addCondition(Condition.predicate(data -> data.itemStack.m_41720_() instanceof BandageItem)).addCondition(Condition.predicate(data -> data.target != null)).addCondition(Condition.predicate(data -> !(data.event instanceof PlayerInteractEvent.RightClickBlock))).addCondition(Condition.predicate(Effects::canUse)).addConfig((IConfigurable)this.bandageGroup.name("Bandage").comment("Config for a Bandage item.")).addConfig((IConfigurable)this.goldenBandageGroup.name("GoldenBandage").comment("Config for a Golden Bandage item.")).insertTo(group);
        }

        private void useBandage(OnPlayerInteract.Data data) {
            Villager villager;
            Player player = data.player;
            LivingEntity target = data.target;
            ItemStack itemStack = data.itemStack;
            assert (target != null);
            player.m_21011_(data.event.getHand(), true);
            Effects.setCooldown(player);
            Effects.removeBleeding(itemStack, player, target);
            if (target instanceof Villager && (villager = (Villager)target).m_21023_((MobEffect)Registries.BLEEDING.get())) {
                Effects.increaseReputation(villager, player);
            }
            this.applyEffects(itemStack, target);
            ItemHelper.consumeItemOnUse((ItemStack)itemStack, (Player)player);
            SoundHandler.ITEM_PICKUP.play(target.m_9236_(), target.m_20182_());
            data.event.setCancellationResult(InteractionResult.SUCCESS);
        }

        private void applyEffects(ItemStack itemStack, LivingEntity target) {
            if (itemStack.m_41720_() instanceof GoldenBandageItem) {
                this.goldenRegeneration.apply(target);
                this.goldenImmunity.apply(target);
            } else {
                this.regeneration.apply(target);
            }
        }

        private static void setCooldown(Player player) {
            int duration = Utility.secondsToTicks((double)0.7);
            ItemHelper.addCooldown((Player)player, (int)duration, (Item[])new Item[]{(Item)Registries.BANDAGE.get(), (Item)Registries.GOLDEN_BANDAGE.get()});
        }

        private static boolean canUse(OnPlayerInteract.Data data) {
            return !ItemHelper.isOnCooldown((Player)data.player, (Item[])new Item[]{(Item)Registries.BANDAGE.get(), (Item)Registries.GOLDEN_BANDAGE.get()});
        }

        private static void increaseReputation(Villager villager, Player player) {
            villager.m_35517_().m_26191_(player.m_20148_(), GossipType.MINOR_POSITIVE, 5);
        }

        private static void removeBleeding(ItemStack itemStack, Player player, LivingEntity target) {
            BleedingEffect bleeding = (BleedingEffect)((Object)Registries.BLEEDING.get());
            if (target.m_21023_((MobEffect)bleeding) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Registries.BANDAGE_TRIGGER.trigger(serverPlayer, (BandageItem)itemStack.m_41720_(), target.equals((Object)serverPlayer));
            }
            target.m_21195_((MobEffect)bleeding);
        }
    }
}

