/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.items.CustomItemTier;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.ConfigGroup;
import com.mlib.config.EffectConfig;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnDamaged;
import com.mlib.gamemodifiers.contexts.OnItemAttributeTooltip;
import com.mlib.items.ItemHelper;
import com.mlib.mobeffects.MobEffectHelper;
import com.mlib.text.TextHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;

public class WitherSwordItem
extends SwordItem {
    public WitherSwordItem() {
        super((Tier)CustomItemTier.WITHER, 3, -2.4f, new Item.Properties().m_41497_(Rarity.UNCOMMON));
    }

    @AutoInstance
    public static class Effect {
        static final String ATTRIBUTE_ID = "item.majruszsdifficulty.wither_sword.effect";
        final EffectConfig wither = new EffectConfig(MobEffects.f_19615_, 1, 6.0);

        public Effect() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("WitherSwordEffect").comment("Wither Sword inflicts wither effect.");
            OnDamaged.listen(this::applyWither).addCondition(Condition.predicate(data -> ItemHelper.hasInMainHand((LivingEntity)data.attacker, (Class[])new Class[]{WitherSwordItem.class}))).addCondition(Condition.predicate(data -> data.source.m_7640_() == data.attacker)).addConfig((IConfigurable)this.wither).insertTo(group);
            OnItemAttributeTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> data.item instanceof WitherSwordItem)).insertTo(group);
        }

        private void applyWither(OnDamaged.Data data) {
            MobEffectHelper.tryToApply((LivingEntity)data.target, (MobEffect)MobEffects.f_19615_, (int)this.wither.getDuration(), (int)this.wither.getAmplifier());
        }

        private void addTooltip(OnItemAttributeTooltip.Data data) {
            String chance = TextHelper.percent((float)1.0f);
            String amplifier = TextHelper.toRoman((int)(this.wither.getAmplifier() + 1));
            data.add(EquipmentSlot.MAINHAND, (Component)Component.m_237110_((String)ATTRIBUTE_ID, (Object[])new Object[]{chance, amplifier}).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }
}

