/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.itemsets;

import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.annotations.AutoInstance;
import com.mlib.effects.ParticleHandler;
import com.mlib.entities.EntityHelper;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.contexts.OnChorusFruitTeleport;
import com.mlib.gamemodifiers.contexts.OnDeath;
import com.mlib.gamemodifiers.contexts.OnEnderManAnger;
import com.mlib.gamemodifiers.contexts.OnLootLevel;
import com.mlib.itemsets.BonusData;
import com.mlib.itemsets.ItemData;
import com.mlib.itemsets.ItemSet;
import com.mlib.levels.LevelHelper;
import com.mlib.mobeffects.MobEffectHelper;
import com.mlib.time.Time;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

@AutoInstance
public class EnderiumSet
extends ItemSet {
    static final MobEffect[] EFFECTS = new MobEffect[]{MobEffects.f_19617_, MobEffects.f_19600_, MobEffects.f_19606_, MobEffects.f_19607_, MobEffects.f_19603_, MobEffects.f_19596_, MobEffects.f_19618_};
    static final ItemData ITEM_1 = new ItemData(Registries.ENDERIUM_HELMET, new EquipmentSlot[]{EquipmentSlot.HEAD});
    static final ItemData ITEM_2 = new ItemData(Registries.ENDERIUM_CHESTPLATE, new EquipmentSlot[]{EquipmentSlot.CHEST});
    static final ItemData ITEM_3 = new ItemData(Registries.ENDERIUM_LEGGINGS, new EquipmentSlot[]{EquipmentSlot.LEGS});
    static final ItemData ITEM_4 = new ItemData(Registries.ENDERIUM_BOOTS, new EquipmentSlot[]{EquipmentSlot.FEET});
    static final BonusData BONUS_1 = new BonusData((itemSet, entity) -> ITEM_1.isEquipped(entity), "majruszsdifficulty.sets.enderium.bonus_1", (itemSet, entity) -> Component.m_237115_((String)"item.majruszsdifficulty.enderium_helmet"), new Object[0]);
    static final BonusData BONUS_2 = new BonusData(2, "majruszsdifficulty.sets.enderium.bonus_2", new Object[0]);
    static final BonusData BONUS_3 = new BonusData(3, "majruszsdifficulty.sets.enderium.bonus_3", new Object[]{Items.f_42730_.m_41466_()});
    static final BonusData BONUS_4 = new BonusData(4, "majruszsdifficulty.sets.enderium.bonus_4", new Object[0]);

    public EnderiumSet() {
        super(() -> Stream.of(ITEM_1, ITEM_2, ITEM_3, ITEM_4), () -> Stream.of(BONUS_1, BONUS_2, BONUS_3, BONUS_4), ChatFormatting.DARK_PURPLE, "majruszsdifficulty.sets.enderium.name");
        OnEnderManAnger.listen(this::cancelAnger).addCondition(Condition.predicate(data -> BONUS_1.isConditionMet((ItemSet)this, (LivingEntity)data.player)));
        OnLootLevel.listen(this::increaseLuck).addCondition(Condition.predicate(data -> data.attacker != null)).addCondition(Condition.predicate(data -> data.getLevel().m_46472_() == Level.f_46430_)).addCondition(Condition.predicate(data -> BONUS_2.isConditionMet((ItemSet)this, data.attacker)));
        OnChorusFruitTeleport.listen(this::giveRandomPotionEffect).addCondition(Condition.predicate(data -> BONUS_3.isConditionMet((ItemSet)this, data.event.getEntityLiving())));
        OnDeath.listen(this::cancelDeath).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> BONUS_4.isConditionMet((ItemSet)this, data.target))).addCondition(Condition.predicate(data -> data.target.m_20186_() < (double)(data.target.m_9236_().m_141937_() - 64))).addCondition(Condition.predicate(data -> data.source.m_276093_(DamageTypes.f_268724_))).addCondition(Condition.predicate(data -> data.target instanceof ServerPlayer));
    }

    private void cancelAnger(OnEnderManAnger.Data data) {
        data.event.setCanceled(true);
    }

    private void increaseLuck(OnLootLevel.Data data) {
        data.event.setLootingLevel(data.event.getLootingLevel() + 1);
    }

    private void giveRandomPotionEffect(OnChorusFruitTeleport.Data data) {
        List<MobEffect> notAppliedEffects = Stream.of(EFFECTS).filter(effect -> MobEffectHelper.getAmplifier((LivingEntity)data.event.getEntityLiving(), (MobEffect)effect) == -1).toList();
        MobEffectHelper.tryToApply((LivingEntity)data.event.getEntityLiving(), (MobEffect)((MobEffect)Random.nextRandom(!notAppliedEffects.isEmpty() ? notAppliedEffects : List.of(EFFECTS))), (int)Utility.minutesToTicks((double)1.5), (int)0);
        data.event.setCanceled(true);
    }

    private void cancelDeath(OnDeath.Data data) {
        EntityHelper.cheatDeath((LivingEntity)data.target, (float)1.0f, (boolean)false);
        data.target.m_20334_(0.0, 0.2, 0.0);
        LevelHelper.teleportToSpawnPosition((ServerPlayer)((ServerPlayer)data.target));
        Time.slider((double)3.0, slider -> ParticleHandler.PORTAL.spawn((ServerLevel)data.target.m_9236_(), data.target.m_20182_(), (int)Math.ceil(slider.getRatioLeft() * 5.0f)));
        data.event.setCanceled(true);
    }
}

