/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.itemsets;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.contexts.OnSoulJarMultiplier;
import com.mlib.annotations.AutoInstance;
import com.mlib.attributes.AttributeHandler;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.contexts.OnFoodPropertiesGet;
import com.mlib.gamemodifiers.contexts.OnItemEquipped;
import com.mlib.itemsets.BonusData;
import com.mlib.itemsets.ItemData;
import com.mlib.itemsets.ItemSet;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Items;

@AutoInstance
public class UndeadSet
extends ItemSet {
    static final FoodProperties FLESH_NO_EFFECT = new FoodProperties.Builder().m_38760_(4).m_38758_(0.1f).m_38757_().m_38767_();
    static final FoodProperties FLESH_EXTRA_HUNGER = new FoodProperties.Builder().m_38760_(8).m_38758_(0.1f).m_38757_().m_38767_();
    static final AttributeHandler ARMOR_ATTRIBUTE = new AttributeHandler("6bf545e0-8f10-483b-9c2d-6ab369e2cb1f", "UndeadSetArmorBonus", Attributes.f_22284_, AttributeModifier.Operation.ADDITION);
    static final int EXTRA_ARMOR = 5;
    static final ItemData ITEM_1 = new ItemData(Registries.TATTERED_HELMET, new EquipmentSlot[]{EquipmentSlot.HEAD});
    static final ItemData ITEM_2 = new ItemData(Registries.TATTERED_CHESTPLATE, new EquipmentSlot[]{EquipmentSlot.CHEST});
    static final ItemData ITEM_3 = new ItemData(Registries.TATTERED_LEGGINGS, new EquipmentSlot[]{EquipmentSlot.LEGS});
    static final ItemData ITEM_4 = new ItemData(Registries.TATTERED_BOOTS, new EquipmentSlot[]{EquipmentSlot.FEET});
    static final BonusData BONUS_1 = new BonusData(2, "majruszsdifficulty.sets.undead.bonus_1", new Object[]{MobEffects.f_19612_.m_19482_(), Items.f_42583_.m_41466_()});
    static final BonusData BONUS_2 = new BonusData(3, "majruszsdifficulty.sets.undead.bonus_2", new Object[]{Items.f_42583_.m_41466_()});
    static final BonusData BONUS_3 = new BonusData(4, "majruszsdifficulty.sets.undead.bonus_3", new Object[]{5});
    static final BonusData BONUS_4 = new BonusData(4, "majruszsdifficulty.sets.undead.bonus_4", new Object[]{Component.m_237115_((String)"item.majruszsdifficulty.soul_jar")});

    public UndeadSet() {
        super(() -> Stream.of(ITEM_1, ITEM_2, ITEM_3, ITEM_4), () -> Stream.of(BONUS_1, BONUS_2, BONUS_3, BONUS_4), ChatFormatting.LIGHT_PURPLE, "majruszsdifficulty.sets.undead.name");
        OnFoodPropertiesGet.listen(this::applyRottenFleshBoost).addCondition(Condition.predicate(data -> data.itemStack.m_41720_().equals(Items.f_42583_))).addCondition(Condition.predicate(data -> data.entity != null));
        OnItemEquipped.listen(this::updateArmorBonus);
        OnSoulJarMultiplier.listen(this::increaseMultiplier).addCondition(Condition.predicate(data -> data.entity instanceof LivingEntity)).addCondition(Condition.predicate(data -> BONUS_4.isConditionMet((ItemSet)this, (LivingEntity)data.entity)));
    }

    private void applyRottenFleshBoost(OnFoodPropertiesGet.Data data) {
        if (BONUS_2.isConditionMet((ItemSet)this, data.entity)) {
            data.properties = FLESH_EXTRA_HUNGER;
        } else if (BONUS_1.isConditionMet((ItemSet)this, data.entity)) {
            data.properties = FLESH_NO_EFFECT;
        }
    }

    private void updateArmorBonus(OnItemEquipped.Data data) {
        int armorBonus = BONUS_3.isConditionMet((ItemSet)this, data.entity) ? 5 : 0;
        ARMOR_ATTRIBUTE.setValue((double)armorBonus).apply(data.entity);
    }

    private void increaseMultiplier(OnSoulJarMultiplier.Data data) {
        data.multiplier *= 2.0f;
    }
}

