/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamemodifiers.configs.MobGroupConfig;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.undeadarmy.data.ExtraLootInfo;
import com.mlib.Random;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ModConfigs;
import com.mlib.gamemodifiers.contexts.OnSpawned;
import com.mlib.math.Range;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;

@AutoInstance
public class UndeadArmyPatrol {
    final MobGroupConfig mobGroups = new MobGroupConfig(() -> (EntityType)Random.nextRandom(List.of(EntityType.f_20501_, EntityType.f_20458_)), (Range<Integer>)new Range((Number)2, (Number)4), Registries.getLocation("undead_army/equipment_wave_3"), Registries.getLocation("undead_army/equipment_wave_2"));

    public UndeadArmyPatrol() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("UndeadArmyPatrol").comment("Undead mobs may spawn in groups as the Undead Army Patrol.");
        OnSpawned.listenSafe(this::spawnGroup).addCondition(CustomConditions.gameStageAtLeast(GameStage.NORMAL)).addCondition(Condition.chanceCRD((double)0.0625, (boolean)true)).addCondition(CustomConditions.isNotPartOfGroup(data -> data.target)).addCondition(CustomConditions.isNotPartOfUndeadArmy(data -> data.target)).addCondition(CustomConditions.isNotNearUndeadArmy(data -> data.target)).addCondition(Condition.isServer()).addCondition(Condition.excludable()).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(OnSpawned.is((Class[])new Class[]{Zombie.class, Skeleton.class, Husk.class, Stray.class})).addConfigs(new IConfigurable[]{this.mobGroups.name("Undead")}).insertTo(group);
    }

    private void spawnGroup(OnSpawned.Data data) {
        PathfinderMob leader = (PathfinderMob)data.target;
        List<PathfinderMob> mobs = this.mobGroups.spawn(leader);
        mobs.add(leader);
        mobs.forEach(ExtraLootInfo::addExtraLootTag);
    }
}

