/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.components;

import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.components.IComponent;
import com.majruszsdifficulty.undeadarmy.data.Phase;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

record MessageSender(UndeadArmy undeadArmy) implements IComponent
{
    @Override
    public void onStateChanged() {
        if (this.undeadArmy.phase.state != Phase.State.FINISHED) {
            this.sendChatMessage();
        }
    }

    private void sendChatMessage() {
        this.getChatMessageId().ifPresent(message -> this.undeadArmy.participants.forEach(participant -> participant.m_5661_((Component)message, false)));
    }

    private Optional<MutableComponent> getChatMessageId() {
        if (this.undeadArmy.phase.state == Phase.State.WAVE_PREPARING && this.undeadArmy.currentWave == 0) {
            String directionId = this.undeadArmy.direction.toString().toLowerCase();
            MutableComponent direction = Component.m_237115_((String)String.format("majruszsdifficulty.undead_army.%s", directionId));
            MutableComponent approaching = Component.m_237110_((String)"majruszsdifficulty.undead_army.approaching", (Object[])new Object[]{direction});
            return Optional.of(approaching.m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if (this.undeadArmy.phase.state == Phase.State.WAVE_ONGOING && this.undeadArmy.currentWave == 1) {
            MutableComponent approached = Component.m_237115_((String)"majruszsdifficulty.undead_army.approached");
            return Optional.of(approached.m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_PURPLE}));
        }
        return Optional.empty();
    }
}

