/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.level;

import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2360;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5217;
import net.minecraft.class_5268;
import org.jetbrains.annotations.Nullable;

public class LevelHelper {
    public static class_1266 getDifficultyAt(class_1937 level, class_2338 position) {
        return level.method_8404(position);
    }

    public static double getRegionalDifficultyAt(class_1937 level, class_2338 position) {
        return LevelHelper.getDifficultyAt(level, position).method_5457();
    }

    public static double getClampedRegionalDifficultyAt(class_1937 level, class_2338 position) {
        return LevelHelper.getDifficultyAt(level, position).method_5458();
    }

    public static boolean isRainingAt(class_1937 level, class_2338 position) {
        return level.method_8520(position);
    }

    public static boolean isDayAt(class_1937 level) {
        return level.method_8530();
    }

    public static boolean isNightAt(class_1937 level) {
        return level.method_23886();
    }

    public static boolean isMobGriefingEnabled(class_1937 level) {
        return level.method_8450().method_8355(class_1928.field_19388);
    }

    public static Optional<SpawnPoint> getSpawnPoint(class_3222 player) {
        float angle;
        Optional spawnPosition;
        class_2338 respawnPosition = player.method_26280();
        class_3218 level = player.field_13995.method_3847(player.method_26281());
        class_243 position = null;
        if (level == null) {
            return Optional.empty();
        }
        if (respawnPosition != null && (spawnPosition = class_1657.method_26091((class_3218)level, (class_2338)respawnPosition, (float)(angle = player.method_30631()), (boolean)true, (boolean)true)).isPresent()) {
            position = (class_243)spawnPosition.get();
        }
        if (position == null) {
            level = player.field_13995.method_3847(class_1937.field_25179);
            position = AnyPos.from(level.method_43126()).vec3();
        }
        return Optional.of(new SpawnPoint(level, position));
    }

    public static boolean teleportNearby(class_1309 target, class_3218 level, double offset) {
        class_243 position = AnyPos.from(target.method_19538()).add(Random.nextDouble(-offset, offset), 0.0, Random.nextDouble(-offset, offset)).vec3();
        class_2338 blockPos = LevelHelper.findBlockPosOnGround((class_1937)level, position, 3).orElse(null);
        if (blockPos != null && target.method_6082((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), true)) {
            SoundEmitter.of(class_3417.field_14879).position(position).emit((class_1937)level);
            ParticleEmitter.of((class_2394)class_2398.field_11214).count(10).position(position).emit((class_1937)level);
            return true;
        }
        return false;
    }

    public static void freezeWater(class_1297 entity, double radius, int minimumIceDuration, int maximumIceDuration) {
        LevelHelper.freezeWater(entity, radius, minimumIceDuration, maximumIceDuration, true);
    }

    public static void freezeWater(class_1297 entity, double radius, int minimumIceDuration, int maximumIceDuration, boolean requireOnGround) {
        if (requireOnGround && !entity.method_24828()) {
            return;
        }
        class_2680 iceBlockState = class_2246.field_10110.method_9564();
        class_2338 entityPosition = entity.method_24515();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        Iterable blocksInRange = class_2338.method_10097((class_2338)entityPosition.method_10069((int)(-radius), -1, (int)(-radius)), (class_2338)entityPosition.method_10069((int)radius, -1, (int)radius));
        for (class_2338 blockPos : blocksInRange) {
            if (!blockPos.method_19771((class_2382)entityPosition, radius)) continue;
            mutableBlockPos.method_10103(blockPos.method_10263(), blockPos.method_10264() + 1, blockPos.method_10260());
            class_2680 blockState = entity.method_37908().method_8320((class_2338)mutableBlockPos);
            if (!blockState.method_26215()) continue;
            class_2680 blockState2 = entity.method_37908().method_8320(blockPos);
            boolean meltsIntoFrostedIceBlock = blockState2 == class_2360.method_51170();
            boolean canSurvive = iceBlockState.method_26184((class_4538)entity.method_37908(), blockPos);
            boolean isUnobstructed = entity.method_37908().method_8628(iceBlockState, blockPos, class_3726.method_16194());
            if (!meltsIntoFrostedIceBlock || !canSurvive || !isUnobstructed) continue;
            entity.method_37908().method_8501(blockPos, iceBlockState);
            entity.method_37908().method_39279(blockPos, class_2246.field_10110, Random.nextInt(minimumIceDuration, maximumIceDuration));
        }
    }

    public static void spawnItemEntityFlyingTowardsDirection(class_1799 itemStack, class_1937 level, class_243 from, class_243 to) {
        class_243 spawnPosition = AnyPos.from(from).add(Random.nextVector(-0.25, 0.25, 0.125, 0.5, -0.25, 0.25)).vec3();
        class_243 motion = AnyPos.from(to).sub(spawnPosition).mul(0.1).vec3();
        class_1542 itemEntity = new class_1542(level, spawnPosition.field_1352, spawnPosition.field_1351, spawnPosition.field_1350, itemStack);
        itemEntity.method_18799(AnyPos.from(motion).add(0.0, Math.pow(AnyPos.from(motion).len().doubleValue(), 0.5) * 0.25, 0.0).vec3());
        level.method_8649((class_1297)itemEntity);
    }

    public static void startRaining(class_1937 level, int ticks, boolean withThunder) {
        class_5217 class_52172 = level.method_8401();
        if (class_52172 instanceof class_5268) {
            class_5268 data = (class_5268)class_52172;
            data.method_157(true);
            data.method_164(ticks);
            if (withThunder) {
                data.method_147(true);
                data.method_173(ticks);
            }
            data.method_167(0);
        }
    }

    public static void startRaining(class_1937 level, int ticks) {
        LevelHelper.startRaining(level, ticks, false);
    }

    public static void setClearWeather(class_1937 level, int ticks) {
        class_5217 class_52172 = level.method_8401();
        if (class_52172 instanceof class_5268) {
            class_5268 data = (class_5268)class_52172;
            data.method_157(false);
            data.method_164(0);
            data.method_147(false);
            data.method_173(0);
            data.method_167(ticks);
        }
    }

    public static <Type extends Number> Optional<class_2338> findBlockPosOnGround(class_1937 level, class_243 position, Type yOffset) {
        return LevelHelper.findBlockPosOnGround(level, position.field_1352, Range.of(position.field_1351 - yOffset.doubleValue(), position.field_1351 + yOffset.doubleValue()), position.field_1350);
    }

    public static <Type extends Number> Optional<class_2338> findBlockPosOnGround(class_1937 level, Type x, Range<Type> y, Type z) {
        class_2338 blockPos = AnyPos.from(x, y.to, z).block();
        do {
            class_2338 blockPosBelow;
            class_2680 blockStateBelow;
            if (!(blockStateBelow = level.method_8320(blockPosBelow = blockPos.method_10074())).method_26206((class_1922)level, blockPosBelow, class_2350.field_11036)) continue;
            if (!level.method_22347(blockPos)) {
                class_2680 blockState = level.method_8320(blockPos);
                class_265 voxelshape = blockState.method_26220((class_1922)level, blockPos);
                class_2338 blockPosAbove = AnyPos.from(blockPos).add(0, !voxelshape.method_1110() ? voxelshape.method_1105(class_2350.class_2351.field_11052) : 0.0, 0).block();
                if (!blockState.method_26220((class_1922)level, blockPosAbove).method_1110()) continue;
                return Optional.of(blockPosAbove);
            }
            return Optional.of(blockPos);
        } while ((blockPos = blockPos.method_10074()).method_10264() >= ((Number)y.from).intValue() - 1);
        return Optional.empty();
    }

    public static class_2338 getPositionOverFluid(class_1937 level, class_2338 position) {
        class_2338 offset = new class_2338((class_2382)position);
        int y = position.method_10264();
        while (y++ < level.method_31600() && !level.method_8320(offset = AnyPos.from(position.method_10263(), y, position.method_10260()).block()).method_26227().method_15769()) {
        }
        return offset;
    }

    @Nullable
    public static class_1657 getNearestPlayer(class_1937 level, class_2338 position, float maxDistance) {
        return level.method_18459((double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260(), (double)maxDistance, false);
    }

    public static class SpawnPoint {
        public final class_3218 level;
        public final class_243 position;

        public SpawnPoint(class_3218 level, class_243 position) {
            this.level = level;
            this.position = position;
        }

        public void teleport(class_3222 player) {
            player.method_14251(this.level, this.position.field_1352, this.position.field_1351, this.position.field_1350, player.method_36454(), player.method_36455());
        }
    }
}

