/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.mixin;

import com.majruszlibrary.events.OnEntityDamageBlocked;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.OnEntityEffectCheck;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnEntitySwimSpeedMultiplierGet;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.OnItemEaten;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.OnItemSwingDurationGet;
import com.majruszlibrary.events.OnItemUseTicked;
import com.majruszlibrary.events.OnLootingLevelGet;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.mixininterfaces.IMixinLivingEntity;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
public abstract class MixinLivingEntity
implements IMixinLivingEntity {
    @Shadow
    private int field_6222;
    float majruszlibrary$lastDamage = 0.0f;
    float majruszlibrary$swimSpeedMultiplier = 1.0f;

    @Override
    public float majruszlibrary$getSwimSpeedMultiplier() {
        return this.majruszlibrary$swimSpeedMultiplier;
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"hurt (Lnet/minecraft/world/damagesource/DamageSource;F)Z"})
    private void hurt(class_1282 source, float damage, CallbackInfoReturnable<Boolean> callback) {
        this.majruszlibrary$lastDamage = damage;
        class_1309 entity = (class_1309)this;
        if (MixinLivingEntity.majruszlibrary$willBeCancelled(source, entity)) {
            return;
        }
        if (damage == 0.0f || entity.method_6061(source)) {
            Events.dispatch(new OnEntityDamageBlocked(source, entity));
            return;
        }
        OnEntityPreDamaged data = Events.dispatch(new OnEntityPreDamaged(source, entity, damage));
        if (data.isDamageCancelled()) {
            data.target.field_6008 = 20;
            callback.setReturnValue((Object)false);
        } else {
            this.majruszlibrary$lastDamage = data.damage;
            MixinLivingEntity.majruszlibrary$tryToAddMagicParticles(data);
        }
    }

    @ModifyVariable(at=@At(shift=At.Shift.AFTER, value="HEAD"), method={"hurt (Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, ordinal=0)
    private float replacePreDamage(float damage) {
        return this.majruszlibrary$lastDamage;
    }

    @Inject(at={@At(target="Lnet/minecraft/world/damagesource/CombatTracker;recordDamage (Lnet/minecraft/world/damagesource/DamageSource;F)V", shift=At.Shift.BEFORE, value="INVOKE")}, method={"actuallyHurt (Lnet/minecraft/world/damagesource/DamageSource;F)V"})
    private void actuallyHurt(class_1282 source, float damage, CallbackInfo callback) {
        Events.dispatch(new OnEntityDamaged(source, (class_1309)this, damage));
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"die (Lnet/minecraft/world/damagesource/DamageSource;)V"})
    private void die(class_1282 source, CallbackInfo callback) {
        if (Events.dispatch(new OnEntityDied(source, (class_1309)this)).isDeathCancelled()) {
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"canBeAffected (Lnet/minecraft/world/effect/MobEffectInstance;)Z"})
    private void canBeAffected(class_1293 effect, CallbackInfoReturnable<Boolean> callback) {
        if (Events.dispatch(new OnEntityEffectCheck(effect, (class_1309)this)).isEffectCancelled()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick ()V"})
    private void tick(CallbackInfo callback) {
        Events.dispatch(new OnEntityTicked((class_1309)this));
        this.majruszlibrary$swimSpeedMultiplier = Events.dispatch(new OnEntitySwimSpeedMultiplierGet((class_1309)this, 1.0f)).getMultiplier();
    }

    @Inject(at={@At(target="Lnet/minecraft/world/entity/LivingEntity;equipmentHasChanged (Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z", value="INVOKE")}, locals=LocalCapture.CAPTURE_FAILHARD, method={"collectEquipmentChanges ()Ljava/util/Map;"})
    private void collectEquipmentChanges(CallbackInfoReturnable<Map<class_1304, class_1799>> callback, Map<class_1304, class_1799> map, class_1304[] slots, int slotsCount, int idx, class_1304 slot, class_1799 from, class_1799 to) {
        if (!class_1799.method_7973((class_1799)from, (class_1799)to)) {
            Events.dispatch(new OnItemEquipped((class_1309)this, slot, from, to));
        }
    }

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"getCurrentSwingDuration ()I"})
    private void getCurrentSwingDuration(CallbackInfoReturnable<Integer> callback) {
        callback.setReturnValue((Object)Events.dispatch(new OnItemSwingDurationGet((class_1309)this, (Integer)callback.getReturnValue())).getSwingDuration());
    }

    @Inject(at={@At(value="HEAD")}, method={"updateUsingItem (Lnet/minecraft/world/item/ItemStack;)V"})
    private void updateUsingItem(class_1799 itemStack, CallbackInfo callback) {
        OnItemUseTicked data = Events.dispatch(new OnItemUseTicked((class_1309)this, itemStack, itemStack.method_7935(), this.field_6222));
        this.field_6222 = data.getDuration();
    }

    @Inject(at={@At(value="HEAD")}, method={"dropAllDeathLoot (Lnet/minecraft/world/damagesource/DamageSource;)V"})
    private void dropAllDeathLoot(class_1282 source, CallbackInfo callback) {
        OnLootingLevelGet.Cache.SOURCE = source;
    }

    @Inject(at={@At(value="HEAD")}, method={"eat (Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"})
    private void eat(class_1937 level, class_1799 itemStack, CallbackInfoReturnable<class_1799> callback) {
        Events.dispatch(new OnItemEaten((class_1309)this, itemStack));
    }

    private static void majruszlibrary$tryToAddMagicParticles(OnEntityPreDamaged data) {
        class_1309 class_13092 = data.attacker;
        if (class_13092 instanceof class_1657) {
            class_1310 type;
            class_1657 player = (class_1657)class_13092;
            class_1297 class_12972 = data.source.method_5529();
            if (class_12972 instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                v0 = entity.method_6046();
            } else {
                v0 = type = class_1310.field_6290;
            }
            if (class_1890.method_8218((class_1799)player.method_6047(), (class_1310)type) > 0.0f) {
                return;
            }
            if (data.spawnCriticalParticles) {
                player.method_7277((class_1297)data.target);
            }
            if (data.spawnMagicParticles) {
                player.method_7304((class_1297)data.target);
            }
        }
    }

    private static boolean majruszlibrary$willBeCancelled(class_1282 source, class_1309 target) {
        boolean isInvulnerable = target.method_5679(source);
        boolean isClientSide = !(target.method_37908() instanceof class_3218);
        boolean isDeadOrDying = target.method_29504();
        boolean isFireResistant = source.method_48789(class_8103.field_42246) && target.method_6059(class_1294.field_5918);
        return isInvulnerable || isClientSide || isDeadOrDying || isFireResistant;
    }
}

