/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.registry;

import com.majruszlibrary.annotation.Dist;
import com.majruszlibrary.annotation.OnlyIn;
import com.majruszlibrary.events.OnParticlesRegisteredFabric;
import com.majruszlibrary.mixin.IMixinCriteriaTriggers;
import com.majruszlibrary.mixin.IMixinSpawnPlacements;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.registry.Custom;
import com.majruszlibrary.registry.IRegistryPlatform;
import com.majruszlibrary.registry.RegistryCallbacks;
import com.majruszlibrary.registry.RegistryGroup;
import com.majruszlibrary.registry.RegistryObject;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4002;
import net.minecraft.class_5132;
import net.minecraft.class_5272;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5617;
import net.minecraft.class_6395;
import net.minecraft.class_6880;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class RegistryFabric
implements IRegistryPlatform {
    @Override
    public <Type> void register(RegistryGroup<Type> group) {
    }

    @Override
    public <Type> void register(RegistryObject<Type> object) {
        Object value = object.newInstance.get();
        class_2378.method_10230(object.group.registry, (class_2960)object.group.helper.getLocation(object.id), value);
        object.set(() -> value, () -> true);
    }

    @Override
    public void register(RegistryCallbacks callbacks) {
        callbacks.execute(Custom.Advancements.class, this::registerAdvancement);
        callbacks.execute(Custom.Attributes.class, this::registerAttribute);
        callbacks.execute(Custom.PotionRecipe.class, this::registerPotionRecipe);
        callbacks.execute(Custom.SpawnPlacements.class, this::registerSpawnPlacement);
        Side.runOnClient(() -> () -> {
            callbacks.execute(Custom.ItemProperties.class, this::registerItemProperty);
            callbacks.execute(Custom.ModelLayers.class, this::registerModelLayer);
            callbacks.execute(Custom.Particles.class, this::registerParticle);
            callbacks.execute(Custom.Renderers.class, this::registerRenderer);
        });
    }

    @Override
    public IRegistryPlatform.IAccessor<class_1792> getItems() {
        return new Accessor<class_1792>((class_2378<class_1792>)class_7923.field_41178);
    }

    @Override
    public IRegistryPlatform.IAccessor<class_1291> getEffects() {
        return new Accessor<class_1291>(class_7923.field_41174);
    }

    @Override
    public IRegistryPlatform.IAccessor<class_1887> getEnchantments() {
        return new Accessor<class_1887>(class_7923.field_41176);
    }

    @Override
    public IRegistryPlatform.IAccessor<class_1299<?>> getEntityTypes() {
        return new Accessor((class_2378<class_1299<?>>)class_7923.field_41177);
    }

    @Override
    public IRegistryPlatform.IAccessor<class_3414> getSoundEvents() {
        return new Accessor<class_3414>(class_7923.field_41172);
    }

    @Override
    public Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    private <Type extends class_179<?>> void registerAdvancement(Type trigger) {
        IMixinCriteriaTriggers.register(trigger);
    }

    private <Type extends class_1309> void registerAttribute(class_1299<Type> type, class_5132 attributes) {
        FabricDefaultAttributeRegistry.register(type, (class_5132)attributes);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemProperty(class_1792 item, class_2960 id, class_6395 property) {
        class_5272.method_27879((class_1792)item, (class_2960)id, (class_6395)property);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerModelLayer(class_5601 id, Supplier<class_5607> definition) {
        EntityModelLayerRegistry.registerModelLayer((class_5601)id, definition::get);
    }

    @OnlyIn(value=Dist.CLIENT)
    private <Type extends class_2394> void registerParticle(class_2396<Type> type, Function<class_4002, class_707<Type>> factory) {
        OnParticlesRegisteredFabric.listen(data -> data.engine.method_18834(type, factory::apply));
    }

    private void registerPotionRecipe(Supplier<? extends class_1842> input, Supplier<? extends class_1792> item, Supplier<? extends class_1842> output) {
        FabricBrewingRecipeRegistry.registerPotionRecipe((class_1842)input.get(), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)item.get()}), (class_1842)output.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    private <Type extends class_1297> void registerRenderer(class_1299<Type> type, class_5617<Type> factory) {
        EntityRendererRegistry.register(type, factory);
    }

    private <Type extends class_1308> void registerSpawnPlacement(class_1299<Type> entityType, class_1317.class_1319 type, class_2902.class_2903 heightmap, class_1317.class_4306<Type> predicate) {
        IMixinSpawnPlacements.register(entityType, type, heightmap, predicate);
    }

    private static class Accessor<Type>
    implements IRegistryPlatform.IAccessor<Type> {
        private final class_2378<Type> registry;

        public Accessor(class_2378<Type> registry) {
            this.registry = registry;
        }

        @Override
        public class_2960 getId(Type value) {
            return this.registry.method_10221(value);
        }

        @Override
        public Type get(class_2960 id) {
            return (Type)this.registry.method_10223(id);
        }

        @Override
        public Iterable<Type> get() {
            return this.registry;
        }

        @Override
        public class_6880<Type> getHolder(Type value) {
            return this.registry.method_47983(value);
        }

        @Override
        @NotNull
        public Iterator<Type> iterator() {
            return this.registry.iterator();
        }
    }
}

