/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnEntityEffectCheck;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.effects.bleeding.BleedingConfig;
import com.majruszsdifficulty.events.OnBleedingTooltip;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class BleedingArmorProtection {
    private static float BASE_BONUS = 0.09f;
    private static float ARMOR_BONUS = 0.03f;
    private static float TOUGHNESS_BONUS = 0.03f;

    private static float calculateCancelChance(OnEntityEffectCheck data) {
        float chance = 1.0f;
        for (class_1304 slot : EquipmentSlots.ARMOR) {
            class_1792 class_17922 = data.entity.method_6118(slot).method_7909();
            if (!(class_17922 instanceof class_1738)) continue;
            class_1738 armorItem = (class_1738)class_17922;
            chance *= 1.0f - BleedingArmorProtection.getArmorMultiplier(armorItem);
        }
        return 1.0f - chance;
    }

    private static void addTooltip(OnBleedingTooltip data) {
        data.addArmor(class_1309.method_32326((class_1799)data.itemStack), BleedingArmorProtection.getArmorMultiplier((class_1738)data.itemStack.method_7909()));
    }

    private static float getArmorMultiplier(class_1738 item) {
        return 1.0f - ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(0.9f)).clamp((Number)Float.valueOf(BASE_BONUS + ARMOR_BONUS * (float)item.method_7687() + TOUGHNESS_BONUS * item.method_26353()))).floatValue();
    }

    static {
        OnEntityEffectCheck.listen(OnEntityEffectCheck::cancelEffect).addCondition(Condition.isLogicalServer()).addCondition(data -> data.effect.equals(MajruszsDifficulty.BLEEDING_EFFECT.get())).addCondition(data -> Random.check((float)BleedingArmorProtection.calculateCancelChance(data)));
        OnBleedingTooltip.listen(BleedingArmorProtection::addTooltip).addCondition(data -> data.itemStack.method_7909() instanceof class_1738);
        Serializables.getStatic(BleedingConfig.class).define("chance_multiplier_base", Reader.number(), () -> Float.valueOf(BASE_BONUS), v -> {
            BASE_BONUS = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)).clamp((Number)v)).floatValue();
        }).define("chance_multiplier_per_armor", Reader.number(), () -> Float.valueOf(ARMOR_BONUS), v -> {
            ARMOR_BONUS = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)).clamp((Number)v)).floatValue();
        }).define("chance_multiplier_per_armor_toughness", Reader.number(), () -> Float.valueOf(TOUGHNESS_BONUS), v -> {
            TOUGHNESS_BONUS = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)).clamp((Number)v)).floatValue();
        });
    }
}

