/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.entity.EffectHelper;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.events.type.ICancellableEvent;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.effects.Bleeding;
import com.majruszsdifficulty.events.OnBleedingCheck;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;

public class BleedingDamage {
    static final int DAMAGE_COOLDOWN = TimeHelper.toTicks((double)4.0);
    static final Map<Integer, Integer> ENTITY_TICKS = new HashMap<Integer, Integer>();

    private static void tryToApply(OnEntityDamaged data) {
        if (((OnBleedingCheck)Events.dispatch((ICancellableEvent)new OnBleedingCheck(data))).isBleedingTriggered() && Bleeding.apply(data.target, data.attacker)) {
            BleedingDamage.dealDamage(data.target);
            BleedingDamage.giveAdvancements(data);
        }
    }

    private static void tick(OnEntityTicked data) {
        int amplifier = EffectHelper.getAmplifier(MajruszsDifficulty.BLEEDING_EFFECT, (class_1309)data.entity).orElse(0);
        int extraDuration = Random.round((double)(0.3 * (double)(amplifier + 2) * (7.26 * (double)EntityHelper.getWalkDistanceDelta((class_1309)data.entity) + 1.0)));
        int duration = ENTITY_TICKS.getOrDefault(data.entity.method_5628(), 0) + extraDuration;
        if (duration > DAMAGE_COOLDOWN) {
            BleedingDamage.dealDamage(data.entity);
            duration = 0;
        }
        ENTITY_TICKS.put(data.entity.method_5628(), duration);
    }

    private static void dealDamage(class_1309 entity) {
        class_6880.class_6883 damageType = entity.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(MajruszsDifficulty.BLEEDING_DAMAGE_SOURCE);
        class_1293 class_12932 = entity.method_6112((class_1291)MajruszsDifficulty.BLEEDING_EFFECT.get());
        if (class_12932 instanceof Bleeding.MobEffectInstance) {
            Bleeding.MobEffectInstance effectInstance = (Bleeding.MobEffectInstance)class_12932;
            class_243 motion = entity.method_18798();
            entity.method_5643(new class_1282((class_6880)damageType, null, effectInstance.damageSourceEntity), 1.0f);
            entity.method_18799(motion);
        } else {
            entity.method_5643(new class_1282((class_6880)damageType), 1.0f);
        }
    }

    private static void giveAdvancements(OnEntityDamaged data) {
        class_3222 player;
        class_1309 class_13092 = data.target;
        if (class_13092 instanceof class_3222) {
            player = (class_3222)class_13092;
            MajruszsDifficulty.HELPER.triggerAchievement(player, "bleeding_received");
            if (data.source.method_49708(class_8111.field_42344)) {
                MajruszsDifficulty.HELPER.triggerAchievement(player, "cactus_bleeding");
            }
        }
        if ((class_13092 = data.attacker) instanceof class_3222) {
            player = (class_3222)class_13092;
            MajruszsDifficulty.HELPER.triggerAchievement(player, "bleeding_inflicted");
        }
    }

    static {
        OnEntityDamaged.listen(BleedingDamage::tryToApply).addCondition(Condition.isLogicalServer()).addCondition(Bleeding::isEnabled).addCondition(data -> Bleeding.canApplyTo(data.target));
        OnEntityTicked.listen(BleedingDamage::tick).addCondition(Condition.isLogicalServer()).addCondition(data -> EffectHelper.has(MajruszsDifficulty.BLEEDING_EFFECT, (class_1309)data.entity));
    }
}

