/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entity;

import com.majruszlibrary.animations.Animations;
import com.majruszlibrary.animations.AnimationsDef;
import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.OnEntityEffectCheck;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.modhelper.Resource;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class Cerberus
extends class_1588
implements IAnimableEntity {
    private static final Resource<AnimationsDef> ANIMATIONS = MajruszsDifficulty.HELPER.load("cerberus_animation", AnimationsDef.class);
    private final Animations animations = Animations.create();

    public static class_1299<Cerberus> createEntityType() {
        return class_1299.class_1300.method_5903(Cerberus::new, (class_1311)class_1311.field_6302).method_17687(1.2f, 1.75f).method_5905("cerberus");
    }

    public static class_5132 createAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 240.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_23718, 0.5).method_26866();
    }

    public Cerberus(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
    }

    public int method_6110() {
        return Random.nextInt((int)26, (int)46);
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    public float method_49476() {
        return 1.6f;
    }

    public void method_5783(class_3414 sound, float volume, float pitch) {
        if (!this.method_5701()) {
            SoundEmitter.of((class_3414)sound).volume(SoundEmitter.randomized((float)volume)).pitch(SoundEmitter.randomized((float)(pitch * 0.75f))).source(this.method_5634()).position(this.method_19538()).emit(this.method_37908());
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5972()) {
            this.method_5639(8);
        }
    }

    public AnimationsDef getAnimationsDef() {
        return (AnimationsDef)ANIMATIONS.get();
    }

    public Animations getAnimations() {
        return this.animations;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14575;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 1.6f;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15027;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15122;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(class_3417.field_14955, 0.15f, 1.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new CerberusMeleeAttackGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    private static void applyWither(OnEntityDamaged data) {
        data.target.method_6092(new class_1293(class_1294.field_5920, TimeHelper.toTicks((double)10.0), 1));
    }

    private static void spawnParticle(OnEntityTicked data) {
        ParticleEmitter.of((class_2394)class_2398.field_11251).sizeBased((class_1297)data.entity).count(1).offset(() -> new class_243(0.25, 0.5, 0.25)).speed(ParticleEmitter.speed((float)0.001f, (float)0.002f)).emit(data.getLevel());
    }

    static {
        OnEntityDamaged.listen(Cerberus::applyWither).addCondition(OnEntityDamaged::isDirect).addCondition(data -> data.attacker instanceof Cerberus);
        OnEntityEffectCheck.listen(OnEntityEffectCheck::cancelEffect).addCondition(data -> data.effect.equals(class_1294.field_5920)).addCondition(data -> data.entity instanceof Cerberus);
        OnEntityTicked.listen(Cerberus::spawnParticle).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)0.2f)).addCondition(data -> data.entity instanceof Cerberus);
    }

    private static class CerberusMeleeAttackGoal
    extends class_1366 {
        private final Cerberus cerberus;
        private int fireballCooldownLeft = 0;

        public CerberusMeleeAttackGoal(Cerberus cerberus) {
            super((class_1314)cerberus, 1.5, true);
            this.cerberus = cerberus;
        }

        public void method_6268() {
            super.method_6268();
            this.cerberus.method_19540(!this.cerberus.animations.isEmpty());
            this.fireballCooldownLeft = Math.max(this.fireballCooldownLeft - 1, 0);
        }

        protected void method_6288(class_1309 target, double distanceSqr) {
            if (!this.cerberus.animations.isEmpty() || !(target.method_37908() instanceof class_3218)) {
                return;
            }
            if (distanceSqr > 100.0 && this.fireballCooldownLeft == 0) {
                this.fireballCooldownLeft = TimeHelper.toTicks((double)10.0);
                this.method_28346();
                this.useFireBreath(target);
            } else if (distanceSqr < this.method_6289(target)) {
                this.method_28346();
                this.bite(target);
            }
        }

        private void useFireBreath(class_1309 target) {
            this.cerberus.playAnimation("fire_breath").addCallback(3, () -> this.spawnFireballTowards(target)).addCallback(11, () -> this.spawnFireballTowards(target)).addCallback(19, () -> this.spawnFireballTowards(target));
        }

        private void bite(class_1309 target) {
            this.cerberus.playAnimation("bite").addCallback(2, () -> this.cerberus.method_5783(class_3417.field_14724, 0.5f, 0.8f)).addCallback(3, () -> this.cerberus.method_5783(class_3417.field_14724, 0.5f, 0.7f)).addCallback(4, () -> this.cerberus.method_5783(class_3417.field_14724, 0.5f, 0.9f)).addCallback(7, () -> this.hitAllNearbyEntities((class_3218)target.method_37908()));
        }

        private void hitAllNearbyEntities(class_3218 level) {
            class_243 position = AnyPos.from((class_243)this.cerberus.method_19538()).add(EntityHelper.getDirection2d((class_1297)this.cerberus).mul((Number)1.5)).vec3();
            for (class_1309 entity : EntityHelper.getEntitiesNearby(class_1309.class, (class_3218)level, (class_243)position, (double)2.0)) {
                class_3222 player;
                if (entity.equals((Object)this.cerberus) || !this.cerberus.method_18391(entity, class_4051.field_18092)) continue;
                this.cerberus.method_6121((class_1297)entity);
                if (!(entity instanceof class_3222) || !(player = (class_3222)entity).method_6039()) continue;
                player.method_7284(true);
            }
        }

        private void spawnFireballTowards(class_1309 target) {
            class_243 offset = AnyPos.from((class_243)target.method_19538()).sub(this.field_6503.method_19538()).vec3();
            for (double angle : new double[]{-30.0, 0.0, 30.0}) {
                class_243 power = AnyPos.from((class_243)offset).mul(Random.nextVector((double)0.8, (double)1.2, (double)0.8, (double)1.2, (double)0.8, (double)1.2)).vec3();
                double cos = Math.cos(Math.toRadians(angle));
                double sin = Math.sin(Math.toRadians(angle));
                class_243 normalized = AnyPos.from((class_243)offset).norm().vec3();
                normalized = new class_243(cos * normalized.field_1352 - sin * normalized.field_1350, normalized.field_1351, sin * normalized.field_1352 + cos * normalized.field_1350);
                class_243 spawnPosition = AnyPos.from((class_243)this.field_6503.method_19538()).add(normalized).add((Number)0.0, (Number)Random.nextDouble((double)1.2, (double)1.5), (Number)0.0).vec3();
                class_1677 fireball = new class_1677(this.field_6503.method_37908(), (class_1309)this.field_6503, power.field_1352, power.field_1351, power.field_1350);
                fireball.method_5814(spawnPosition.field_1352, spawnPosition.field_1351, spawnPosition.field_1350);
                fireball.method_18799(AnyPos.from((class_243)power).norm().mul((Number)0.25).vec3());
                this.field_6503.method_37908().method_8649((class_1297)fireball);
            }
            SoundEmitter.of((class_3414)class_3417.field_15006).position(this.field_6503.method_19538()).emit(this.field_6503.method_37908());
        }
    }
}

