/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entity;

import com.majruszlibrary.animations.Animations;
import com.majruszlibrary.animations.AnimationsDef;
import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.modhelper.Resource;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.bloodmoon.BloodMoonHelper;
import com.majruszsdifficulty.data.Config;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2595;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class CursedArmor
extends class_1588
implements IAnimableEntity {
    private static final Resource<AnimationsDef> ANIMATIONS = MajruszsDifficulty.HELPER.load("cursed_armor_animation", AnimationsDef.class);
    private static float ITEM_DROP_CHANCE = 0.2f;
    private static float NAME_CHANCE = 0.025f;
    private static List<String> NAMES = List.of("Freshah");
    private static List<LocationDef> LOCATIONS = List.of(new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_dungeon"), List.of(new class_2960("chests/simple_dungeon")), 0.5f), new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_stronghold"), List.of(new class_2960("chests/stronghold_corridor"), new class_2960("chests/stronghold_crossing"), new class_2960("chests/stronghold_library")), 0.4f), new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_portal"), List.of(new class_2960("chests/ruined_portal")), 1.0f), new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_nether"), List.of(new class_2960("chests/bastion_bridge"), new class_2960("chests/bastion_hoglin_stable"), new class_2960("chests/bastion_other"), new class_2960("chests/bastion_treasure"), new class_2960("chests/nether_bridge")), 0.25f), new LocationDef(MajruszsDifficulty.HELPER.getLocation("gameplay/cursed_armor_end"), List.of(new class_2960("chests/end_city_treasure")), 0.5f));
    private final Animations animations = Animations.create();

    public static class_1299<CursedArmor> createEntityType() {
        return class_1299.class_1300.method_5903(CursedArmor::new, (class_1311)class_1311.field_6302).method_17687(0.5f, 1.9f).method_5905("cursed_armor");
    }

    public static class_5132 createAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23718, 0.23).method_26868(class_5134.field_23724, 4.0).method_26866();
    }

    public static boolean checkMonsterSpawnRules(class_1299<? extends class_1588> entityType, class_5425 level, class_3730 mobSpawnType, class_2338 blockPos, class_5819 random) {
        return class_1588.method_20680(entityType, (class_5425)level, (class_3730)mobSpawnType, (class_2338)blockPos, (class_5819)random) && BloodMoonHelper.isActive();
    }

    public CursedArmor(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
    }

    public boolean method_6094() {
        return true;
    }

    public int method_6110() {
        return 7;
    }

    public AnimationsDef getAnimationsDef() {
        return (AnimationsDef)ANIMATIONS.get();
    }

    public Animations getAnimations() {
        return this.animations;
    }

    public void assemble() {
        if (this.animations.isEmpty()) {
            this.playAnimation("assemble").addCallback(27, () -> {
                class_1792 patt8471$temp = this.method_6118(class_1304.field_6174).method_7909();
                if (patt8471$temp instanceof class_1738) {
                    class_1738 armorItem = (class_1738)patt8471$temp;
                    SoundEmitter.of((class_3414)armorItem.method_31570()).source(class_3419.field_15251).position(this.method_19538()).emit(this.method_37908());
                }
            });
        }
    }

    public void equip(LocationDef locationDef) {
        LootHelper.getLootTable((class_2960)locationDef.loot).method_51878(LootHelper.toGiftParams((class_1297)this)).forEach(itemStack -> {
            if (itemStack.method_7909() instanceof class_1819) {
                this.method_5673(class_1304.field_6171, (class_1799)itemStack);
            } else {
                ItemHelper.equip((class_1308)this, (class_1799)itemStack);
            }
        });
        EquipmentSlots.ALL.forEach(slot -> this.method_5946((class_1304)slot, ITEM_DROP_CHANCE));
    }

    public boolean isAssembling() {
        return !this.animations.isEmpty();
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new AssembleGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    private static Optional<LocationDef> find(class_2960 chestId) {
        return LOCATIONS.stream().filter(locationDef -> locationDef.chests.stream().anyMatch(arg_0 -> ((class_2960)chestId).equals(arg_0))).findFirst();
    }

    private static LocationDef getRandomLocationDef() {
        return (LocationDef)Random.next(LOCATIONS);
    }

    private static void spawnCursedArmor(OnLootGenerated data) {
        TimeHelper.nextTick(delay -> {
            CursedArmor cursedArmor = (CursedArmor)EntityHelper.createSpawner(MajruszsDifficulty.CURSED_ARMOR_ENTITY, (class_1937)data.getLevel()).position(CursedArmor.getSpawnPosition(data)).beforeEvent(entity -> {
                float yRot = BlockHelper.getState((class_1937)data.getLevel(), (class_243)data.origin).method_28500((class_2769)class_2281.field_10768).map(class_2350::method_10144).orElse(Float.valueOf((float)Random.nextInt((int)0, (int)4) * 90.0f)).floatValue();
                entity.method_36456(yRot);
                entity.method_5847(yRot);
                entity.method_5636(yRot);
            }).spawn();
            if (cursedArmor != null) {
                cursedArmor.assemble();
                cursedArmor.equip(CursedArmor.find(data.lootId).orElseThrow());
                class_1297 patt10948$temp = data.entity;
                if (patt10948$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt10948$temp;
                    TimeHelper.nextTick(subdelay -> player.method_7346());
                }
            }
        });
    }

    private static void giveRandomArmor(OnEntitySpawned data) {
        CursedArmor cursedArmor = (CursedArmor)data.entity;
        if (cursedArmor.method_18396() == 0.0f) {
            cursedArmor.assemble();
            cursedArmor.equip(CursedArmor.getRandomLocationDef());
        }
    }

    private static void setCustomName(OnEntitySpawned data) {
        data.entity.method_5665((class_2561)TextHelper.literal((String)((String)Random.next(NAMES))));
    }

    private static class_243 getSpawnPosition(OnLootGenerated data) {
        class_3218 level = data.getServerLevel();
        Function<Float, Boolean> isAir = y -> BlockHelper.getState((class_1937)level, (class_243)data.origin.method_1031(0.0, (double)y.floatValue(), 0.0)).method_26215();
        if (isAir.apply(Float.valueOf(1.0f)).booleanValue() && isAir.apply(Float.valueOf(2.0f)).booleanValue()) {
            return data.origin.method_1031(0.0, 0.5, 0.0);
        }
        class_2382 offset = ((class_2350)BlockHelper.getState((class_1937)level, (class_243)data.origin).method_11654((class_2769)class_2281.field_10768)).method_10163();
        return data.origin.method_1031((double)offset.method_10263(), (double)offset.method_10264(), (double)offset.method_10260());
    }

    private static void spawnIdleParticles(OnEntityTicked data) {
        CursedArmor.spawnParticles(data, new class_243(0.0, (double)data.entity.method_17682() * 0.5, 0.0), 0.3, 1);
    }

    private static void spawnAssemblingParticles(OnEntityTicked data) {
        CursedArmor.spawnParticles(data, new class_243(0.0, 0.0, 0.0), 0.6, 5);
    }

    private static void spawnParticles(OnEntityTicked data, class_243 emitterOffset, double offsetMultiplier, int particlesCount) {
        ParticleEmitter.of((class_2394)class_2398.field_11215).position(data.entity.method_19538().method_1019(emitterOffset)).offset(() -> AnyPos.from((Number)Float.valueOf(data.entity.method_17681()), (Number)Float.valueOf(data.entity.method_17682()), (Number)Float.valueOf(data.entity.method_17681())).mul((Number)offsetMultiplier).vec3()).speed(0.5f).count(particlesCount).emit(data.getLevel());
    }

    static {
        OnLootGenerated.listen(CursedArmor::spawnCursedArmor).addCondition(Condition.isLogicalServer()).addCondition(data -> data.getLevel() != null).addCondition(data -> data.origin != null).addCondition(data -> BlockHelper.getEntity((class_1937)data.getLevel(), (class_243)data.origin) instanceof class_2595).addCondition(data -> Random.check((float)CursedArmor.find(data.lootId).map(def -> Float.valueOf(def.chance)).orElse(Float.valueOf(0.0f)).floatValue()));
        OnEntitySpawned.listen(CursedArmor::giveRandomArmor).addCondition(Condition.isLogicalServer()).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.entity instanceof CursedArmor);
        OnEntitySpawned.listen(CursedArmor::setCustomName).addCondition(Condition.isLogicalServer()).addCondition(Condition.chance(() -> Float.valueOf(NAME_CHANCE))).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.entity instanceof CursedArmor);
        OnEntityTicked.listen(CursedArmor::spawnIdleParticles).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)0.2f)).addCondition(data -> data.entity instanceof CursedArmor);
        OnEntityTicked.listen(CursedArmor::spawnAssemblingParticles).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)0.2f)).addCondition(data -> {
            CursedArmor cursedArmor;
            class_1309 patt5808$temp = data.entity;
            return patt5808$temp instanceof CursedArmor && (cursedArmor = (CursedArmor)patt5808$temp).isAssembling();
        });
        OnEntityPreDamaged.listen(OnEntityPreDamaged::cancelDamage).addCondition(data -> {
            CursedArmor cursedArmor;
            class_1309 patt5980$temp = data.target;
            return patt5980$temp instanceof CursedArmor && (cursedArmor = (CursedArmor)patt5980$temp).isAssembling();
        });
        Serializables.getStatic(Config.Mobs.class).define("cursed_armor", CursedArmor.class);
        Serializables.getStatic(CursedArmor.class).define("item_drop_chance", Reader.number(), () -> Float.valueOf(ITEM_DROP_CHANCE), v -> {
            ITEM_DROP_CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("custom_name_chance", Reader.number(), () -> Float.valueOf(NAME_CHANCE), v -> {
            NAME_CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("custom_names", Reader.list((IReader)Reader.string()), () -> NAMES, v -> {
            NAMES = v;
        }).define("locations", Reader.list((IReader)Reader.custom(LocationDef::new)), () -> LOCATIONS, v -> {
            LOCATIONS = v;
        });
        Serializables.get(LocationDef.class).define("loot", Reader.location(), s -> s.loot, (s, v) -> {
            s.loot = v;
        }).define("chests", Reader.list((IReader)Reader.location()), s -> s.chests, (s, v) -> {
            s.chests = v;
        }).define("chance", Reader.number(), s -> Float.valueOf(s.chance), (s, v) -> {
            s.chance = v.floatValue();
        });
    }

    public static class LocationDef {
        public class_2960 loot;
        public List<class_2960> chests;
        public float chance;

        public LocationDef(class_2960 loot, List<class_2960> chests, float chance) {
            this.loot = loot;
            this.chests = chests;
            this.chance = chance;
        }

        public LocationDef() {
            this(null, List.of(), 0.0f);
        }
    }

    public static class AssembleGoal
    extends class_1352 {
        private final CursedArmor cursedArmor;

        public AssembleGoal(CursedArmor cursedArmor) {
            this.cursedArmor = cursedArmor;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.cursedArmor.isAssembling();
        }
    }
}

